/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.dbpool.H2EmbeddedDataSource;
import io.airlift.dbpool.H2EmbeddedDataSourceConfig;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;

public class H2EmbeddedDataSourceModule
implements Module {
    private final Class<? extends Annotation> annotation;
    private final List<Class<? extends Annotation>> aliases;
    private final String propertyPrefix;

    @SafeVarargs
    public H2EmbeddedDataSourceModule(String propertyPrefix, Class<? extends Annotation> annotation, Class<? extends Annotation> ... aliases) {
        if (annotation == null) {
            throw new NullPointerException("annotation is null");
        }
        if (propertyPrefix == null) {
            throw new NullPointerException("propertyPrefix is null");
        }
        if (propertyPrefix.isEmpty()) {
            throw new IllegalArgumentException("propertyPrefix is empty");
        }
        this.annotation = annotation;
        this.propertyPrefix = propertyPrefix;
        this.aliases = aliases != null ? ImmutableList.copyOf((Object[])aliases) : Collections.emptyList();
    }

    public void configure(Binder binder) {
        binder.install((Module)new MBeanModule());
        ConfigBinder.configBinder((Binder)binder).bindConfig(H2EmbeddedDataSourceConfig.class, this.annotation, this.propertyPrefix);
        binder.bind(DataSource.class).annotatedWith(this.annotation).toProvider((Provider)new H2EmbeddedDataSourceProvider(this.annotation)).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DataSource.class).annotatedWith(this.annotation).withGeneratedName();
        Key key = Key.get(DataSource.class, this.annotation);
        for (Class<? extends Annotation> alias : this.aliases) {
            binder.bind(DataSource.class).annotatedWith(alias).to(key);
        }
    }

    private static class H2EmbeddedDataSourceProvider
    implements Provider<H2EmbeddedDataSource> {
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private H2EmbeddedDataSourceProvider(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public H2EmbeddedDataSource get() {
            H2EmbeddedDataSourceConfig config = (H2EmbeddedDataSourceConfig)this.injector.getInstance(Key.get(H2EmbeddedDataSourceConfig.class, this.annotation));
            try {
                return new H2EmbeddedDataSource(config);
            }
            catch (Exception e) {
                throw new ProvisionException("Error creating a H2EmbeddedDataSource", (Throwable)e);
            }
        }
    }
}

