/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.airlift.dbpool.ManagedDataSourceConfig;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"db.mvcc.enabled"})
public class H2EmbeddedDataSourceConfig
extends ManagedDataSourceConfig<H2EmbeddedDataSourceConfig> {
    private String filename;
    private String filePassword;
    private String initScript;
    private AllowLiterals allowLiterals = AllowLiterals.ALL;
    private CompressLob compressLob = CompressLob.LZF;
    private Cipher cipher = Cipher.NONE;
    private int cacheSize = 16384;
    private long maxLengthInplaceLob = 1024L;
    private long maxMemoryRows = 10000L;

    @NotNull
    public String getFilename() {
        return this.filename;
    }

    @Config(value="db.filename")
    public H2EmbeddedDataSourceConfig setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public String getFilePassword() {
        return this.filePassword;
    }

    @Config(value="db.file-password")
    @ConfigSecuritySensitive
    public H2EmbeddedDataSourceConfig setFilePassword(String filePassword) {
        this.filePassword = filePassword;
        return this;
    }

    public String getInitScript() {
        return this.initScript;
    }

    @Config(value="db.init-script")
    public H2EmbeddedDataSourceConfig setInitScript(String initScript) {
        this.initScript = initScript;
        return this;
    }

    public AllowLiterals getAllowLiterals() {
        return this.allowLiterals;
    }

    @Config(value="db.allow-literals")
    public H2EmbeddedDataSourceConfig setAllowLiterals(AllowLiterals allowLiterals) {
        if (allowLiterals == null) {
            throw new NullPointerException("allowLiterals is null");
        }
        this.allowLiterals = allowLiterals;
        return this;
    }

    public CompressLob getCompressLob() {
        return this.compressLob;
    }

    @Config(value="db.compress-lob")
    public H2EmbeddedDataSourceConfig setCompressLob(CompressLob compressLob) {
        if (compressLob == null) {
            throw new NullPointerException("compressLob is null");
        }
        this.compressLob = compressLob;
        return this;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    @Config(value="db.cipher")
    public H2EmbeddedDataSourceConfig setCipher(Cipher cipher) {
        if (cipher == null) {
            throw new NullPointerException("cipher is null");
        }
        this.cipher = cipher;
        return this;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Config(value="db.cache-size")
    public H2EmbeddedDataSourceConfig setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public long getMaxLengthInplaceLob() {
        return this.maxLengthInplaceLob;
    }

    @Config(value="db.inplace.lob.length.max")
    public H2EmbeddedDataSourceConfig setMaxLengthInplaceLob(long maxLengthInplaceLob) {
        this.maxLengthInplaceLob = maxLengthInplaceLob;
        return this;
    }

    public long getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    @Config(value="db.rows.memory.max")
    public H2EmbeddedDataSourceConfig setMaxMemoryRows(long maxMemoryRows) {
        this.maxMemoryRows = maxMemoryRows;
        return this;
    }

    public static enum Cipher {
        NONE,
        AES,
        XTEA;

    }

    public static enum CompressLob {
        NO,
        LZF,
        DEFLATE;

    }

    public static enum AllowLiterals {
        NONE,
        NUMBERS,
        ALL;

    }
}

