/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.Announcement;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.CachingServiceSelectorFactory;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryClientConfig;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.HttpDiscoveryAnnouncementClient;
import io.airlift.discovery.client.HttpDiscoveryLookupClient;
import io.airlift.discovery.client.MergingServiceSelectorFactory;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceDescriptorsRepresentation;
import io.airlift.discovery.client.ServiceInventory;
import io.airlift.discovery.client.ServiceInventoryConfig;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorFactory;
import io.airlift.discovery.client.ServiceSelectorManager;
import io.airlift.discovery.client.ServiceState;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.node.NodeInfo;
import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.PreDestroy;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class DiscoveryModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ServiceInventory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ServiceInventoryConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(DiscoveryClientConfig.class);
        binder.bind(DiscoveryLookupClient.class).to(HttpDiscoveryLookupClient.class).in(Scopes.SINGLETON);
        binder.bind(DiscoveryAnnouncementClient.class).to(HttpDiscoveryAnnouncementClient.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ServiceDescriptorsRepresentation.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Announcement.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("discovery", ForDiscoveryClient.class);
        binder.bind(Announcer.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(Announcer.class).withGeneratedName();
        Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
        binder.bind(CachingServiceSelectorFactory.class).in(Scopes.SINGLETON);
        binder.bind(ServiceSelectorFactory.class).to(MergingServiceSelectorFactory.class).in(Scopes.SINGLETON);
        binder.bind(ScheduledExecutorService.class).annotatedWith(ForDiscoveryClient.class).toProvider(DiscoveryExecutorProvider.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ServiceSelector.class);
        binder.bind(ServiceSelectorManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ServiceInventory.class).withGeneratedName();
    }

    @Provides
    @ForDiscoveryClient
    public URI getDiscoveryUri(ServiceInventory serviceInventory, DiscoveryClientConfig config) {
        Iterable<ServiceDescriptor> discovery = serviceInventory.getServiceDescriptors("discovery");
        for (ServiceDescriptor descriptor : discovery) {
            if (descriptor.getState() != ServiceState.RUNNING) continue;
            try {
                return new URI(descriptor.getProperties().get("https"));
            }
            catch (Exception exception) {
                try {
                    return new URI(descriptor.getProperties().get("http"));
                }
                catch (Exception exception2) {
                }
            }
        }
        if (config != null) {
            return config.getDiscoveryServiceURI();
        }
        return null;
    }

    @Provides
    @Singleton
    public MergingServiceSelectorFactory createMergingServiceSelectorFactory(CachingServiceSelectorFactory factory, Announcer announcer, NodeInfo nodeInfo) {
        return new MergingServiceSelectorFactory(factory, announcer, nodeInfo);
    }

    private static class DiscoveryExecutorProvider
    implements Provider<ScheduledExecutorService> {
        private ScheduledExecutorService executor;

        private DiscoveryExecutorProvider() {
        }

        public ScheduledExecutorService get() {
            Preconditions.checkState((this.executor == null ? 1 : 0) != 0, (Object)"provider already used");
            this.executor = new ScheduledThreadPoolExecutor(5, Threads.daemonThreadsNamed((String)"Discovery-%s"));
            return this.executor;
        }

        @PreDestroy
        public void destroy() {
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
    }
}

