/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ExponentialBackOff;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceDescriptors;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;

public class CachingServiceSelector
implements ServiceSelector {
    private static final Logger log = Logger.get(CachingServiceSelector.class);
    private final String type;
    private final String pool;
    private final DiscoveryLookupClient lookupClient;
    private final AtomicReference<ServiceDescriptors> serviceDescriptors = new AtomicReference();
    private final ScheduledExecutorService executor;
    private final ExponentialBackOff errorBackOff;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public CachingServiceSelector(String type, ServiceSelectorConfig selectorConfig, DiscoveryLookupClient lookupClient, ScheduledExecutorService executor) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        Objects.requireNonNull(lookupClient, "client is null");
        Objects.requireNonNull(executor, "executor is null");
        this.type = type;
        this.pool = selectorConfig.getPool();
        this.lookupClient = lookupClient;
        this.executor = executor;
        this.errorBackOff = new ExponentialBackOff(new Duration(1.0, TimeUnit.MILLISECONDS), new Duration(1.0, TimeUnit.SECONDS), String.format("Discovery server connect succeeded for refresh (%s/%s)", type, this.pool), String.format("Cannot connect to discovery server for refresh (%s/%s)", type, this.pool), log);
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            Preconditions.checkState((!this.executor.isShutdown() ? 1 : 0) != 0, (Object)"CachingServiceSelector has been destroyed");
            try {
                this.refresh().get(1L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        ServiceDescriptors serviceDescriptors = this.serviceDescriptors.get();
        if (serviceDescriptors == null) {
            return ImmutableList.of();
        }
        return serviceDescriptors.getServiceDescriptors();
    }

    @Override
    public ListenableFuture<List<ServiceDescriptor>> refresh() {
        ServiceDescriptors oldDescriptors = this.serviceDescriptors.get();
        ListenableFuture<ServiceDescriptors> future = oldDescriptors == null ? this.lookupClient.getServices(this.type, this.pool) : this.lookupClient.refreshServices(oldDescriptors);
        future = CachingServiceSelector.chainedCallback(future, new FutureCallback<ServiceDescriptors>(){

            public void onSuccess(ServiceDescriptors newDescriptors) {
                CachingServiceSelector.this.serviceDescriptors.set(newDescriptors);
                CachingServiceSelector.this.errorBackOff.success();
                Duration delay = newDescriptors.getMaxAge();
                if (delay == null) {
                    delay = DiscoveryAnnouncementClient.DEFAULT_DELAY;
                }
                CachingServiceSelector.this.scheduleRefresh(delay);
            }

            public void onFailure(Throwable t) {
                Duration duration = CachingServiceSelector.this.errorBackOff.failed(t);
                CachingServiceSelector.this.scheduleRefresh(duration);
            }
        }, this.executor);
        return Futures.transform(future, ServiceDescriptors::getServiceDescriptors, (Executor)MoreExecutors.directExecutor());
    }

    private void scheduleRefresh(Duration delay) {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                CachingServiceSelector.this.refresh();
            }
        }, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static <V> ListenableFuture<V> chainedCallback(ListenableFuture<V> future, final FutureCallback<? super V> callback, Executor executor) {
        final SettableFuture done = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V result) {
                try {
                    callback.onSuccess(result);
                }
                finally {
                    done.set(result);
                }
            }

            public void onFailure(Throwable t) {
                try {
                    callback.onFailure(t);
                }
                finally {
                    done.setException(t);
                }
            }
        }, (Executor)executor);
        return done;
    }
}

