/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.discovery.client.Announcement;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.CacheControl;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonBodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class HttpDiscoveryAnnouncementClient
implements DiscoveryAnnouncementClient {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private static final Logger log = Logger.get(HttpDiscoveryAnnouncementClient.class);
    private final Supplier<URI> discoveryServiceURI;
    private final NodeInfo nodeInfo;
    private final JsonCodec<Announcement> announcementCodec;
    private final HttpClient httpClient;
    private Optional<InetAddress> lastReportedDiscoveryServiceAddress = Optional.empty();
    private boolean priorResolutionSucceeded = true;

    @Inject
    public HttpDiscoveryAnnouncementClient(@ForDiscoveryClient Supplier<URI> discoveryServiceURI, NodeInfo nodeInfo, JsonCodec<Announcement> announcementCodec, @ForDiscoveryClient HttpClient httpClient) {
        Objects.requireNonNull(discoveryServiceURI, "discoveryServiceURI is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(announcementCodec, "announcementCodec is null");
        Objects.requireNonNull(httpClient, "httpClient is null");
        this.nodeInfo = nodeInfo;
        this.discoveryServiceURI = discoveryServiceURI;
        this.announcementCodec = announcementCodec;
        this.httpClient = httpClient;
    }

    @Override
    public ListenableFuture<Duration> announce(Set<ServiceAnnouncement> services) {
        Objects.requireNonNull(services, "services is null");
        URI uri = this.discoveryServiceURI.get();
        if (uri == null) {
            return Futures.immediateFailedFuture((Throwable)new DiscoveryException("No discovery servers are available"));
        }
        HttpDiscoveryAnnouncementClient.reportChangedAddressResolution(uri, this.lastReportedDiscoveryServiceAddress, this.priorResolutionSucceeded).ifPresentOrElse(inetAddr -> {
            this.lastReportedDiscoveryServiceAddress = Optional.of(inetAddr);
            this.priorResolutionSucceeded = true;
        }, () -> {
            this.priorResolutionSucceeded = false;
        });
        Announcement announcement = new Announcement(this.nodeInfo.getEnvironment(), this.nodeInfo.getNodeId(), this.nodeInfo.getPool(), this.nodeInfo.getLocation(), services);
        Request request = Request.Builder.preparePut().setUri(HttpDiscoveryAnnouncementClient.createAnnouncementLocation(uri, this.nodeInfo.getNodeId())).setHeader("User-Agent", this.nodeInfo.getNodeId()).setHeader("Content-Type", MEDIA_TYPE_JSON.toString()).setBodyGenerator((BodyGenerator)JsonBodyGenerator.jsonBodyGenerator(this.announcementCodec, (Object)announcement)).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)new DiscoveryResponseHandler<Duration>(this, "Announcement", uri){

            @Override
            public Duration handle(Request request, Response response) throws DiscoveryException {
                int statusCode = response.getStatusCode();
                if (!HttpDiscoveryAnnouncementClient.isSuccess(statusCode)) {
                    throw new DiscoveryException(String.format("Announcement failed with status code %s: %s", statusCode, HttpDiscoveryAnnouncementClient.getBodyForError(response)));
                }
                Duration maxAge = HttpDiscoveryAnnouncementClient.extractMaxAge(response);
                return maxAge;
            }
        });
    }

    private static boolean isSuccess(int statusCode) {
        return statusCode / 100 == 2;
    }

    private static String getBodyForError(Response response) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return "(error getting body)";
        }
    }

    @Override
    public ListenableFuture<Void> unannounce() {
        URI uri = this.discoveryServiceURI.get();
        if (uri == null) {
            return Futures.immediateFuture(null);
        }
        Request request = Request.Builder.prepareDelete().setUri(HttpDiscoveryAnnouncementClient.createAnnouncementLocation(uri, this.nodeInfo.getNodeId())).setHeader("User-Agent", this.nodeInfo.getNodeId()).build();
        return this.httpClient.executeAsync(request, new DiscoveryResponseHandler(this, "Unannouncement", uri));
    }

    @VisibleForTesting
    static URI createAnnouncementLocation(URI baseUri, String nodeId) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).appendPath("/v1/announcement").appendPath(nodeId).build();
    }

    @VisibleForTesting
    static Optional<InetAddress> reportChangedAddressResolution(URI discoveryServiceURI, Optional<InetAddress> lastReportedDiscoveryServiceAddress, boolean priorResolutionSucceeded) {
        try {
            InetAddress resolvedDiscoveryServiceAddress = InetAddress.getByName(discoveryServiceURI.getHost());
            lastReportedDiscoveryServiceAddress.ifPresent(last -> {
                if (!last.equals(resolvedDiscoveryServiceAddress)) {
                    log.warn("Discovery service address changed from " + String.valueOf(last) + " to " + String.valueOf(resolvedDiscoveryServiceAddress));
                }
            });
            return Optional.of(resolvedDiscoveryServiceAddress);
        }
        catch (UnknownHostException e) {
            if (priorResolutionSucceeded) {
                log.error((Throwable)e, "Discovery Service location URI resolution failed");
            }
            return Optional.empty();
        }
    }

    private static Duration extractMaxAge(Response response) {
        CacheControl cacheControl;
        String header = response.getHeader("Cache-Control");
        if (header != null && (cacheControl = CacheControl.valueOf((String)header)).getMaxAge() > 0) {
            return new Duration((double)cacheControl.getMaxAge(), TimeUnit.SECONDS);
        }
        return DEFAULT_DELAY;
    }

    private class DiscoveryResponseHandler<T>
    implements ResponseHandler<T, DiscoveryException> {
        private final String name;
        private final URI uri;

        protected DiscoveryResponseHandler(HttpDiscoveryAnnouncementClient httpDiscoveryAnnouncementClient, String name, URI uri) {
            this.name = name;
            this.uri = uri;
        }

        public T handle(Request request, Response response) {
            return null;
        }

        public final T handleException(Request request, Exception exception) {
            if (exception instanceof InterruptedException) {
                throw new DiscoveryException(this.name + " was interrupted for " + String.valueOf(this.uri));
            }
            if (exception instanceof CancellationException) {
                throw new DiscoveryException(this.name + " was canceled for " + String.valueOf(this.uri));
            }
            if (exception instanceof DiscoveryException) {
                throw (DiscoveryException)exception;
            }
            throw new DiscoveryException(this.name + " failed for " + String.valueOf(this.uri), exception);
        }
    }
}

