/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.discovery.client.HttpAnnouncementImpl;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.HttpServiceSelectorProvider;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceSelectorProvider;
import io.airlift.discovery.client.ServiceType;
import io.airlift.discovery.client.ServiceTypes;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class DiscoveryBinder {
    private final Multibinder<ServiceSelector> serviceSelectorBinder;
    private final Multibinder<ServiceAnnouncement> serviceAnnouncementBinder;
    private final Binder binder;

    public static DiscoveryBinder discoveryBinder(Binder binder) {
        Objects.requireNonNull(binder, "binder is null");
        return new DiscoveryBinder(binder);
    }

    protected DiscoveryBinder(Binder binder) {
        Objects.requireNonNull(binder, "binder is null");
        this.binder = binder.skipSources(new Class[]{this.getClass()});
        this.serviceSelectorBinder = Multibinder.newSetBinder((Binder)binder, ServiceSelector.class);
        this.serviceAnnouncementBinder = Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
    }

    public void bindSelector(String type) {
        Objects.requireNonNull(type, "type is null");
        this.bindSelector(ServiceTypes.serviceType(type));
    }

    public void bindSelector(ServiceType serviceType) {
        Objects.requireNonNull(serviceType, "serviceType is null");
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(ServiceSelectorConfig.class, (Annotation)serviceType, "discovery." + serviceType.value());
        Key key = Key.get(ServiceSelector.class, (Annotation)serviceType);
        this.binder.bind(key).toProvider((Provider)new ServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
        this.serviceSelectorBinder.addBinding().to(key).in(Scopes.SINGLETON);
    }

    public void bindServiceAnnouncement(ServiceAnnouncement announcement) {
        Objects.requireNonNull(announcement, "announcement is null");
        this.serviceAnnouncementBinder.addBinding().toInstance((Object)announcement);
    }

    public void bindServiceAnnouncement(Provider<ServiceAnnouncement> announcementProvider) {
        Objects.requireNonNull(announcementProvider, "announcementProvider is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProvider);
    }

    public <T extends ServiceAnnouncement> void bindServiceAnnouncement(Class<? extends Provider<T>> announcementProviderClass) {
        Objects.requireNonNull(announcementProviderClass, "announcementProviderClass is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProviderClass);
    }

    public HttpAnnouncementBindingBuilder bindHttpAnnouncement(String type) {
        return this.bindHttpAnnouncement(type, null);
    }

    public HttpAnnouncementBindingBuilder bindHttpAnnouncement(String type, Class<? extends Annotation> bindingAnnotation) {
        HttpAnnouncementImpl annotation = new HttpAnnouncementImpl(type + "." + String.valueOf(UUID.randomUUID()));
        MapBinder propertiesBinder = MapBinder.newMapBinder((Binder)this.binder, String.class, String.class, (Annotation)annotation);
        this.bindServiceAnnouncement(new HttpAnnouncementProvider(type, annotation, Optional.ofNullable(bindingAnnotation)));
        return new HttpAnnouncementBindingBuilder((MapBinder<String, String>)propertiesBinder);
    }

    public void bindHttpSelector(String type) {
        Objects.requireNonNull(type, "type is null");
        this.bindHttpSelector(ServiceTypes.serviceType(type));
    }

    public void bindHttpSelector(ServiceType serviceType) {
        Objects.requireNonNull(serviceType, "serviceType is null");
        this.bindSelector(serviceType);
        this.binder.bind(HttpServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new HttpServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    static <T> Key<T> qualifiedKey(Optional<Class<? extends Annotation>> qualifier, Class<T> type) {
        return qualifier.map(annotation -> Key.get((Class)type, (Class)annotation)).orElseGet(() -> Key.get((Class)type));
    }

    public static class HttpAnnouncementBindingBuilder {
        private final MapBinder<String, String> propertiesBinder;

        public HttpAnnouncementBindingBuilder(MapBinder<String, String> propertiesBinder) {
            this.propertiesBinder = Objects.requireNonNull(propertiesBinder, "propertiesBinder is null");
        }

        @CanIgnoreReturnValue
        public HttpAnnouncementBindingBuilder addProperty(String key, String value) {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(value, "value is null");
            this.propertiesBinder.addBinding((Object)key).toInstance((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public HttpAnnouncementBindingBuilder addProperties(Map<String, String> properties) {
            properties.forEach(this::addProperty);
            return this;
        }

        @CanIgnoreReturnValue
        public HttpAnnouncementBindingBuilder bindPropertyProvider(String key, Provider<String> provider) {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(provider, "provider is null");
            this.propertiesBinder.addBinding((Object)key).toProvider(provider);
            return this;
        }

        @CanIgnoreReturnValue
        public HttpAnnouncementBindingBuilder bindPropertyProvider(String key, Class<? extends Provider<String>> providerType) {
            return this.bindPropertyProvider(key, (Key<? extends Provider<String>>)Key.get(providerType));
        }

        @CanIgnoreReturnValue
        public HttpAnnouncementBindingBuilder bindPropertyProvider(String key, Key<? extends Provider<String>> providerKey) {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(providerKey, "providerKey is null");
            this.propertiesBinder.addBinding((Object)key).toProvider(providerKey);
            return this;
        }
    }

    static class HttpAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private final String type;
        private final Annotation annotation;
        private final Optional<Class<? extends Annotation>> announcementAnnotation;
        private Injector injector;

        public HttpAnnouncementProvider(String type, Annotation annotation, Optional<Class<? extends Annotation>> announcementAnnotation) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.annotation = Objects.requireNonNull(annotation, "annotation is null");
            this.announcementAnnotation = Objects.requireNonNull(announcementAnnotation, "announcementAnnotation is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public ServiceAnnouncement get() {
            ServiceAnnouncement.ServiceAnnouncementBuilder builder = ServiceAnnouncement.serviceAnnouncement(this.type);
            builder.addProperties((Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(this){}, (Annotation)this.annotation)));
            AnnouncementHttpServerInfo httpServerInfo = (AnnouncementHttpServerInfo)this.injector.getInstance(DiscoveryBinder.qualifiedKey(this.announcementAnnotation, AnnouncementHttpServerInfo.class));
            if (httpServerInfo.getHttpUri() != null) {
                builder.addProperty("http", httpServerInfo.getHttpUri().toString());
                builder.addProperty("http-external", httpServerInfo.getHttpExternalUri().toString());
            }
            if (httpServerInfo.getHttpsUri() != null) {
                builder.addProperty("https", httpServerInfo.getHttpsUri().toString());
                builder.addProperty("https-external", httpServerInfo.getHttpsExternalUri().toString());
            }
            return builder.build();
        }
    }
}

