/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.airlift.discovery.server.DynamicServiceAnnouncement;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Immutable
public class DynamicAnnouncement {
    private final String environment;
    private final String location;
    private final String pool;
    private final Set<DynamicServiceAnnouncement> services;

    @JsonCreator
    public DynamicAnnouncement(@JsonProperty(value="environment") String environment, @JsonProperty(value="pool") String pool, @JsonProperty(value="location") String location, @JsonProperty(value="services") Set<DynamicServiceAnnouncement> services) {
        this.environment = environment;
        this.location = location;
        this.pool = pool;
        this.services = services != null ? ImmutableSet.copyOf(services) : null;
    }

    @NotNull
    public String getEnvironment() {
        return this.environment;
    }

    public String getLocation() {
        return this.location;
    }

    @NotNull
    public String getPool() {
        return this.pool;
    }

    @NotNull
    @Valid
    public Set<DynamicServiceAnnouncement> getServiceAnnouncements() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicAnnouncement that = (DynamicAnnouncement)o;
        if (!Objects.equals(this.environment, that.environment)) {
            return false;
        }
        if (!Objects.equals(this.location, that.location)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        return Objects.equals(this.services, that.services);
    }

    public int hashCode() {
        int result = this.environment != null ? this.environment.hashCode() : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.pool != null ? this.pool.hashCode() : 0);
        result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DynamicAnnouncement{environment='" + this.environment + "', location='" + this.location + "', pool='" + this.pool + "', services=" + this.services + "}";
    }

    public static Builder copyOf(DynamicAnnouncement announcement) {
        return new Builder().copyOf(announcement);
    }

    public static class Builder {
        private String environment;
        private String location;
        private String pool;
        private Set<DynamicServiceAnnouncement> services;

        public Builder copyOf(DynamicAnnouncement announcement) {
            this.environment = announcement.getEnvironment();
            this.location = announcement.getLocation();
            this.services = announcement.getServiceAnnouncements();
            this.pool = announcement.getPool();
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public DynamicAnnouncement build() {
            return new DynamicAnnouncement(this.environment, this.pool, this.location, this.services);
        }
    }
}

