/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import io.airlift.discovery.server.Id;
import io.airlift.discovery.server.Node;
import io.airlift.discovery.server.StaticAnnouncement;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Service {
    private final Id<Service> id;
    private final Id<Node> nodeId;
    private final String type;
    private final String pool;
    private final String location;
    private final Map<String, String> properties;

    @JsonCreator
    public Service(@JsonProperty(value="id") Id<Service> id, @JsonProperty(value="nodeId") Id<Node> nodeId, @JsonProperty(value="type") String type, @JsonProperty(value="pool") String pool, @JsonProperty(value="location") String location, @JsonProperty(value="properties") Map<String, String> properties) {
        Preconditions.checkNotNull(id, (Object)"id is null");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)pool, (Object)"pool is null");
        Preconditions.checkNotNull((Object)location, (Object)"location is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        this.id = id;
        this.nodeId = nodeId;
        this.type = type;
        this.pool = pool;
        this.location = location;
        this.properties = ImmutableMap.copyOf(properties);
    }

    @JsonProperty
    public Id<Service> getId() {
        return this.id;
    }

    @JsonProperty
    public Id<Node> getNodeId() {
        return this.nodeId;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public String getPool() {
        return this.pool;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service that = (Service)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static Predicate<Service> matchesType(final String type) {
        return new Predicate<Service>(){

            public boolean apply(Service descriptor) {
                return descriptor.getType().equals(type);
            }
        };
    }

    public static Predicate<Service> matchesPool(final String pool) {
        return new Predicate<Service>(){

            public boolean apply(Service descriptor) {
                return descriptor.getPool().equals(pool);
            }
        };
    }

    public String toString() {
        return "Service{id=" + this.id + ", nodeId=" + this.nodeId + ", type='" + this.type + "', pool='" + this.pool + "', location='" + this.location + "', properties=" + this.properties + "}";
    }

    public static Builder copyOf(StaticAnnouncement announcement) {
        return new Builder().copyOf(announcement);
    }

    public static class Builder {
        private Id<Service> id;
        private String type;
        private String pool;
        private String location;
        private Map<String, String> properties;

        public Builder copyOf(StaticAnnouncement announcement) {
            this.type = announcement.getType();
            this.pool = announcement.getPool();
            this.properties = ImmutableMap.copyOf(announcement.getProperties());
            return this;
        }

        public Builder setId(Id<Service> id) {
            this.id = id;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Service build() {
            return new Service(this.id, null, this.type, this.pool, this.location, this.properties);
        }
    }
}

