/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.discovery.server.DynamicStore;
import io.airlift.discovery.server.Service;
import io.airlift.discovery.server.Services;
import io.airlift.discovery.server.StaticStore;
import io.airlift.node.NodeInfo;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Set;

@Path(value="/v1/service")
public class ServiceResource {
    private final DynamicStore dynamicStore;
    private final StaticStore staticStore;
    private final NodeInfo node;

    @Inject
    public ServiceResource(DynamicStore dynamicStore, StaticStore staticStore, NodeInfo node) {
        this.dynamicStore = dynamicStore;
        this.staticStore = staticStore;
        this.node = node;
    }

    @GET
    @Path(value="{type}/{pool}")
    @Produces(value={"application/json"})
    public Services getServices(@PathParam(value="type") String type, @PathParam(value="pool") String pool) {
        return new Services(this.node.getEnvironment(), (Set<Service>)Sets.union(this.dynamicStore.get(type, pool), this.staticStore.get(type, pool)));
    }

    @GET
    @Path(value="{type}")
    @Produces(value={"application/json"})
    public Services getServices(@PathParam(value="type") String type) {
        return new Services(this.node.getEnvironment(), (Set<Service>)Sets.union(this.dynamicStore.get(type), this.staticStore.get(type)));
    }

    @GET
    @Produces(value={"application/json"})
    public Services getServices() {
        return new Services(this.node.getEnvironment(), (Set<Service>)Sets.union(this.dynamicStore.getAll(), this.staticStore.getAll()));
    }
}

