/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.compiler.byteCode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.drift.codec.$internal.asm.tree.FieldNode;
import io.airlift.drift.codec.internal.compiler.byteCode.Access;
import io.airlift.drift.codec.internal.compiler.byteCode.ParameterizedType;
import java.util.EnumSet;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FieldDefinition {
    private final ImmutableSet<Access> access;
    private final String name;
    private final ParameterizedType type;

    public FieldDefinition(EnumSet<Access> access, String name, ParameterizedType type) {
        this.access = Sets.immutableEnumSet(access);
        this.name = name;
        this.type = type;
    }

    public ImmutableSet<Access> getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public FieldNode getFieldNode() {
        return new FieldNode(Access.toAccessModifier(this.access), this.name, this.type.getType(), this.type.getGenericSignature(), null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("access", this.access).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }
}

