/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.collect.ImmutableList;
import io.airlift.drift.codec.metadata.MetadataErrorException;
import io.airlift.drift.codec.metadata.MetadataWarningException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MetadataErrors {
    private final List<MetadataErrorException> errors = new ArrayList<MetadataErrorException>();
    private final List<MetadataWarningException> warnings = new ArrayList<MetadataWarningException>();
    private final Monitor monitor;
    public static final NullMonitor NULL_MONITOR = new NullMonitor();

    public MetadataErrors() {
        this.monitor = NULL_MONITOR;
    }

    public MetadataErrors(Monitor monitor) {
        this.monitor = monitor;
    }

    public void throwIfHasErrors() throws MetadataErrorException {
        if (!this.errors.isEmpty()) {
            MetadataErrorException exception = new MetadataErrorException("Metadata extraction encountered %s errors and %s warnings", this.errors.size(), this.warnings.size());
            for (MetadataErrorException error : this.errors) {
                exception.addSuppressed(error);
            }
            for (MetadataWarningException warning : this.warnings) {
                exception.addSuppressed(warning);
            }
            throw exception;
        }
    }

    public List<MetadataErrorException> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    public void addError(String format, Object ... params) {
        MetadataErrorException message = new MetadataErrorException(format, params);
        this.errors.add(message);
        this.monitor.onError(message);
    }

    public void addError(Throwable e, String format, Object ... params) {
        MetadataErrorException message = new MetadataErrorException(e, format, params);
        this.errors.add(message);
        this.monitor.onError(message);
    }

    public List<MetadataWarningException> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    public void addWarning(String format, Object ... params) {
        MetadataWarningException message = new MetadataWarningException(format, params);
        this.warnings.add(message);
        this.monitor.onWarning(message);
    }

    public void addWarning(Throwable e, String format, Object ... params) {
        MetadataWarningException message = new MetadataWarningException(e, format, params);
        this.warnings.add(message);
        this.monitor.onWarning(message);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (MetadataErrorException error : this.errors) {
            builder.append(error.getMessage()).append('\n');
        }
        for (MetadataWarningException warning : this.warnings) {
            builder.append(warning.getMessage()).append('\n');
        }
        return builder.toString();
    }

    private static final class NullMonitor
    implements Monitor {
        private NullMonitor() {
        }

        @Override
        public void onError(MetadataErrorException unused) {
        }

        @Override
        public void onWarning(MetadataWarningException unused) {
        }
    }

    public static interface Monitor {
        public void onError(MetadataErrorException var1);

        public void onWarning(MetadataWarningException var1);
    }
}

