/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftIdlAnnotation;
import io.airlift.drift.annotations.ThriftUnion;
import io.airlift.drift.annotations.ThriftUnionId;
import io.airlift.drift.codec.metadata.AbstractThriftMetadataBuilder;
import io.airlift.drift.codec.metadata.ConstructorInjection;
import io.airlift.drift.codec.metadata.FieldExtractor;
import io.airlift.drift.codec.metadata.FieldInjection;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.FieldMetadata;
import io.airlift.drift.codec.metadata.MethodExtractor;
import io.airlift.drift.codec.metadata.MethodInjection;
import io.airlift.drift.codec.metadata.ParameterInjection;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftConstructorInjection;
import io.airlift.drift.codec.metadata.ThriftExtraction;
import io.airlift.drift.codec.metadata.ThriftFieldExtractor;
import io.airlift.drift.codec.metadata.ThriftFieldInjection;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftInjection;
import io.airlift.drift.codec.metadata.ThriftMethodExtractor;
import io.airlift.drift.codec.metadata.ThriftMethodInjection;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import io.airlift.drift.codec.metadata.ThriftStructMetadata;
import io.airlift.drift.codec.metadata.ThriftTypeReference;
import io.airlift.drift.codec.metadata.TypeCoercion;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ThriftUnionMetadataBuilder
extends AbstractThriftMetadataBuilder {
    public ThriftUnionMetadataBuilder(ThriftCatalog catalog, Type structType) {
        super(catalog, structType);
        this.verifyClass(ThriftUnion.class);
        this.extractThriftUnionId();
        this.normalizeThriftFields(catalog);
    }

    @Override
    protected String extractName() {
        ThriftUnion annotation = this.getStructClass().getAnnotation(ThriftUnion.class);
        if (annotation == null) {
            return this.getStructClass().getSimpleName();
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return this.getStructClass().getSimpleName();
    }

    @Override
    protected Map<String, String> extractStructIdlAnnotations() {
        ThriftUnion annotation = this.getStructClass().getAnnotation(ThriftUnion.class);
        if (annotation == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ThriftIdlAnnotation idlAnnotation : annotation.idlAnnotations()) {
            builder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
        }
        return builder.build();
    }

    @Override
    protected Class<?> extractBuilderClass() {
        ThriftUnion annotation = this.getStructClass().getAnnotation(ThriftUnion.class);
        if (annotation != null && !annotation.builder().equals(Void.TYPE)) {
            return annotation.builder();
        }
        return null;
    }

    private void extractThriftUnionId() {
        Collection<Field> idFields = ReflectionHelper.findAnnotatedFields(this.getStructClass(), ThriftUnionId.class);
        Collection<Method> idMethods = ReflectionHelper.findAnnotatedMethods(this.getStructClass(), ThriftUnionId.class);
        if (idFields.size() + idMethods.size() != 1) {
            if (idFields.size() + idMethods.size() == 0) {
                this.metadataErrors.addError("Neither a field nor a method is annotated with @ThriftUnionId", new Object[0]);
            } else if (idFields.size() > 1) {
                this.metadataErrors.addError("More than one @ThriftUnionId field present", new Object[0]);
            } else if (idMethods.size() > 1) {
                this.metadataErrors.addError("More than one @ThriftUnionId method present", new Object[0]);
            } else {
                this.metadataErrors.addError("Both fields and methods annotated with @ThriftUnionId", new Object[0]);
            }
            return;
        }
        for (Field idField : idFields) {
            FieldExtractor fieldExtractor = new FieldExtractor(this.structType, idField, null, FieldKind.THRIFT_UNION_ID);
            this.fields.add(fieldExtractor);
            this.extractors.add(fieldExtractor);
            FieldInjection fieldInjection = new FieldInjection(this.structType, idField, null, FieldKind.THRIFT_UNION_ID);
            this.fields.add(fieldInjection);
            this.fieldInjections.add(fieldInjection);
        }
        for (Method idMethod : idMethods) {
            if (!Modifier.isPublic(idMethod.getModifiers())) {
                this.metadataErrors.addError("@ThriftUnionId method [%s] is not public", idMethod.toGenericString());
                continue;
            }
            if (Modifier.isStatic(idMethod.getModifiers())) {
                this.metadataErrors.addError("@ThriftUnionId method [%s] is static", idMethod.toGenericString());
                continue;
            }
            if (!this.isValidateGetter(idMethod)) continue;
            MethodExtractor methodExtractor = new MethodExtractor(this.structType, idMethod, null, FieldKind.THRIFT_UNION_ID);
            this.fields.add(methodExtractor);
            this.extractors.add(methodExtractor);
        }
    }

    @Override
    protected void validateConstructors() {
        for (ConstructorInjection constructorInjection : this.constructorInjections) {
            if (constructorInjection.getParameters().size() <= 1) continue;
            this.metadataErrors.addError("@ThriftConstructor [%s] takes %d arguments, this is illegal for an union", constructorInjection.getConstructor().toGenericString(), constructorInjection.getParameters().size());
        }
    }

    @Override
    protected boolean isValidateSetter(Method method) {
        return method.getParameterTypes().length == 1;
    }

    @Override
    public ThriftStructMetadata build() {
        this.metadataErrors.throwIfHasErrors();
        ThriftMethodInjection builderMethodInjection = this.buildBuilderConstructorInjections();
        ThriftConstructorInjection constructorInjection = this.buildConstructorInjection();
        Iterable<ThriftFieldMetadata> fieldsMetadata = this.buildFieldInjections();
        List<ThriftMethodInjection> methodInjections = this.buildMethodInjections();
        return new ThriftStructMetadata(this.structName, this.extractStructIdlAnnotations(), this.structType, this.builderType, ThriftStructMetadata.MetadataType.UNION, Optional.ofNullable(builderMethodInjection), (List<String>)ImmutableList.copyOf((Collection)this.documentation), (List<ThriftFieldMetadata>)ImmutableList.copyOf(fieldsMetadata), Optional.ofNullable(constructorInjection), methodInjections);
    }

    private ThriftConstructorInjection buildConstructorInjection() {
        for (ConstructorInjection constructorInjection : this.constructorInjections) {
            if (constructorInjection.getParameters().size() != 0) continue;
            return new ThriftConstructorInjection(constructorInjection.getConstructor(), ThriftUnionMetadataBuilder.buildParameterInjections(constructorInjection.getParameters()));
        }
        return null;
    }

    @Override
    protected ThriftFieldMetadata buildField(Collection<FieldMetadata> input) {
        short id = -1;
        boolean isLegacyId = false;
        String name = null;
        boolean recursiveness = false;
        ThriftField.Requiredness requiredness = ThriftField.Requiredness.UNSPECIFIED;
        Map<String, String> idlAnnotations = null;
        FieldKind fieldType = FieldKind.THRIFT_FIELD;
        ThriftTypeReference thriftTypeReference = null;
        ThriftConstructorInjection thriftConstructorInjection = null;
        ThriftMethodInjection thriftMethodInjection = null;
        ImmutableList.Builder injections = ImmutableList.builder();
        ThriftExtraction extraction = null;
        for (FieldMetadata fieldMetadata : input) {
            id = fieldMetadata.getId();
            isLegacyId = fieldMetadata.isLegacyId();
            name = fieldMetadata.getName();
            recursiveness = fieldMetadata.isRecursiveReference();
            requiredness = fieldMetadata.getRequiredness();
            idlAnnotations = fieldMetadata.getIdlAnnotations();
            fieldType = fieldMetadata.getType();
            thriftTypeReference = this.catalog.getFieldThriftTypeReference(fieldMetadata);
            switch (requiredness) {
                case REQUIRED: 
                case OPTIONAL: {
                    this.metadataErrors.addError("Thrift union '%s' field '%s(%s)' should not be marked required or optional", this.structName, name, id);
                    break;
                }
            }
            if (fieldMetadata instanceof FieldInjection) {
                FieldInjection fieldInjection = (FieldInjection)fieldMetadata;
                injections.add((Object)new ThriftFieldInjection(fieldInjection.getId(), fieldInjection.getName(), fieldInjection.getField(), fieldInjection.getType()));
                continue;
            }
            if (fieldMetadata instanceof ParameterInjection) {
                ParameterInjection parameterInjection = (ParameterInjection)fieldMetadata;
                ThriftParameterInjection thriftParameterInjection = new ThriftParameterInjection(parameterInjection.getId(), parameterInjection.getName(), parameterInjection.getParameterIndex(), fieldMetadata.getJavaType());
                injections.add((Object)thriftParameterInjection);
                for (ConstructorInjection constructorInjection : this.constructorInjections) {
                    if (constructorInjection.getParameters().size() != 1 || !constructorInjection.getParameters().get(0).equals(parameterInjection)) continue;
                    thriftConstructorInjection = new ThriftConstructorInjection(constructorInjection.getConstructor(), thriftParameterInjection);
                    break;
                }
                for (MethodInjection methodInjection : this.methodInjections) {
                    if (methodInjection.getParameters().size() != 1 || !methodInjection.getParameters().get(0).equals(parameterInjection)) continue;
                    thriftMethodInjection = new ThriftMethodInjection(methodInjection.getMethod(), thriftParameterInjection);
                }
                continue;
            }
            if (fieldMetadata instanceof FieldExtractor) {
                FieldExtractor fieldExtractor = (FieldExtractor)fieldMetadata;
                extraction = new ThriftFieldExtractor(fieldExtractor.getId(), fieldExtractor.getName(), fieldExtractor.getType(), fieldExtractor.getField(), fieldExtractor.getJavaType());
                continue;
            }
            if (!(fieldMetadata instanceof MethodExtractor)) continue;
            MethodExtractor methodExtractor = (MethodExtractor)fieldMetadata;
            extraction = new ThriftMethodExtractor(methodExtractor.getId(), methodExtractor.getName(), methodExtractor.getType(), methodExtractor.getMethod(), methodExtractor.getJavaType());
        }
        TypeCoercion coercion = null;
        if (!thriftTypeReference.isRecursive() && thriftTypeReference.get().isCoerced()) {
            coercion = this.catalog.getDefaultCoercion(thriftTypeReference.get().getJavaType());
        }
        return new ThriftFieldMetadata(id, isLegacyId, recursiveness, requiredness, idlAnnotations, thriftTypeReference, name, fieldType, (List<ThriftInjection>)injections.build(), Optional.ofNullable(thriftConstructorInjection), Optional.ofNullable(thriftMethodInjection), Optional.ofNullable(extraction), Optional.ofNullable(coercion));
    }
}

