/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class ThriftHeaderParameter {
    private final int index;
    private final String name;

    public ThriftHeaderParameter(int index, String name) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index is negative");
        this.index = index;
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftHeaderParameter that = (ThriftHeaderParameter)o;
        return this.index == that.index && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("name", (Object)this.name).toString();
    }
}

