/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.reflection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.internal.ProtocolReader;
import io.airlift.drift.codec.internal.ProtocolWriter;
import io.airlift.drift.codec.internal.reflection.AbstractReflectionThriftCodec;
import io.airlift.drift.codec.internal.reflection.ReflectionThriftStructCodec;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ThriftConstructorInjection;
import io.airlift.drift.codec.metadata.ThriftFieldInjection;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftInjection;
import io.airlift.drift.codec.metadata.ThriftMethodInjection;
import io.airlift.drift.codec.metadata.ThriftStructMetadata;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@Immutable
public class ReflectionThriftUnionCodec<T>
extends AbstractReflectionThriftCodec<T> {
    private final Map<Short, ThriftFieldMetadata> metadataMap;
    private final Map.Entry<ThriftFieldMetadata, ThriftCodec<?>> idField;

    public ReflectionThriftUnionCodec(ThriftCodecManager manager, ThriftStructMetadata metadata) {
        super(manager, metadata);
        ThriftFieldMetadata idField = (ThriftFieldMetadata)Iterables.getOnlyElement(metadata.getFields(FieldKind.THRIFT_UNION_ID));
        this.idField = Maps.immutableEntry((Object)idField, manager.getCodec(idField.getThriftType()));
        Objects.requireNonNull(this.idField.getValue(), () -> "No codec for ID field found: " + String.valueOf(idField));
        this.metadataMap = Maps.uniqueIndex(metadata.getFields(), ThriftFieldMetadata::getId);
    }

    @Override
    public T read(TProtocolReader protocol) throws Exception {
        ProtocolReader reader = new ProtocolReader(protocol);
        reader.readStructBegin();
        Map.Entry data = null;
        Short fieldId = null;
        while (reader.nextField()) {
            Preconditions.checkState((fieldId == null ? 1 : 0) != 0, (String)"Received Union with more than one value (seen id %s, now id %s)", fieldId, (int)reader.getFieldId());
            fieldId = reader.getFieldId();
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldId);
            if (codec == null) {
                reader.skipFieldData();
                continue;
            }
            ThriftFieldMetadata field = this.metadata.getField(fieldId.shortValue());
            if (field.isWriteOnly() || field.getType() != FieldKind.THRIFT_FIELD) {
                reader.skipFieldData();
                continue;
            }
            Object value = reader.readField(codec);
            if (value == null) continue;
            data = Maps.immutableEntry((Object)fieldId, (Object)value);
        }
        reader.readStructEnd();
        return this.constructStruct(data);
    }

    @Override
    public void write(T instance, TProtocolWriter protocol) throws Exception {
        ProtocolWriter writer = new ProtocolWriter(protocol);
        Short idValue = (Short)this.getFieldValue(instance, this.idField.getKey());
        writer.writeStructBegin(this.metadata.getStructName());
        if (this.metadataMap.containsKey(idValue)) {
            ThriftFieldMetadata fieldMetadata = this.metadataMap.get(idValue);
            if (fieldMetadata.isReadOnly() || fieldMetadata.getType() != FieldKind.THRIFT_FIELD) {
                throw new IllegalStateException(String.format("Field %s is not readable", fieldMetadata.getName()));
            }
            Object fieldValue = this.getFieldValue(instance, fieldMetadata);
            if (fieldValue != null) {
                ThriftCodec codec = (ThriftCodec)this.fields.get(fieldMetadata.getId());
                writer.writeField(fieldMetadata.getName(), fieldMetadata.getId(), codec, fieldValue);
            }
        }
        writer.writeStructEnd();
    }

    private T constructStruct(Map.Entry<Short, Object> data) throws Exception {
        ThriftFieldInjection fieldInjection;
        Object instance = null;
        ThriftFieldMetadata fieldMetadata = null;
        if (data != null && (fieldMetadata = this.metadataMap.get(data.getKey())) != null && fieldMetadata.getConstructorInjection().isPresent()) {
            instance = ReflectionThriftStructCodec.invokeConstructor(fieldMetadata.getConstructorInjection().get().getConstructor(), new Object[]{data.getValue()});
        }
        if (instance == null && this.metadata.getConstructorInjection().isPresent()) {
            Iterator<ThriftInjection> constructor = this.metadata.getConstructorInjection().get();
            instance = ReflectionThriftStructCodec.invokeConstructor(((ThriftConstructorInjection)((Object)constructor)).getConstructor(), new Object[0]);
        }
        if (fieldMetadata != null) {
            for (ThriftInjection injection : fieldMetadata.getInjections()) {
                if (!(injection instanceof ThriftFieldInjection)) continue;
                fieldInjection = (ThriftFieldInjection)injection;
                if (data.getValue() == null) continue;
                fieldInjection.getField().set(instance, data.getValue());
            }
            if (fieldMetadata.getMethodInjection().isPresent() && data.getValue() != null) {
                ReflectionThriftStructCodec.invokeMethod(fieldMetadata.getMethodInjection().get().getMethod(), instance, new Object[]{data.getValue()});
            }
        }
        if (data != null) {
            for (ThriftInjection injection : this.idField.getKey().getInjections()) {
                if (!(injection instanceof ThriftFieldInjection)) continue;
                fieldInjection = (ThriftFieldInjection)injection;
                fieldInjection.getField().set(instance, data.getKey());
            }
            if (this.metadata.getBuilderMethod().isPresent()) {
                ThriftMethodInjection builderMethod = this.metadata.getBuilderMethod().get();
                instance = ReflectionThriftStructCodec.invokeMethod(builderMethod.getMethod(), instance, new Object[]{data.getValue()});
                ReflectionThriftStructCodec.validateCreatedInstance(this.metadata.getStructClass(), instance);
            }
        }
        return (T)instance;
    }
}

