/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.codec.metadata.Extractor;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

class FieldExtractor
extends Extractor {
    private final Type thriftStructType;
    private final Field field;

    FieldExtractor(Type thriftStructType, Field field, ThriftField annotation, FieldKind fieldKind) {
        super(annotation, fieldKind);
        this.thriftStructType = thriftStructType;
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String extractName() {
        return this.field.getName();
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.field.getGenericType());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).toString();
    }
}

