/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ThriftInjection;
import java.lang.reflect.Field;
import java.util.Objects;

@Immutable
public class ThriftFieldInjection
implements ThriftInjection {
    private final short id;
    private final String name;
    private final Field field;
    private final FieldKind fieldKind;

    public ThriftFieldInjection(short id, String name, Field field, FieldKind fieldKind) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.field = Objects.requireNonNull(field, "field is null");
        this.fieldKind = Objects.requireNonNull(fieldKind, "fieldKind is null");
        switch (fieldKind) {
            case THRIFT_FIELD: {
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((id == Short.MIN_VALUE ? 1 : 0) != 0, (Object)"fieldId must be Short.MIN_VALUE for thrift_union_id");
            }
        }
        this.id = id;
    }

    @Override
    public FieldKind getFieldKind() {
        return this.fieldKind;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (int)this.id).add("name", (Object)this.name).add("field", (Object)this.field).add("fieldKind", (Object)this.fieldKind).toString();
    }
}

