/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.builtin;

import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.internal.ProtocolReader;
import io.airlift.drift.codec.internal.ProtocolWriter;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.util.Objects;

@Immutable
public class DoubleArrayThriftCodec
implements ThriftCodec<double[]> {
    @Override
    public ThriftType getType() {
        return ThriftType.array(ThriftType.DOUBLE);
    }

    @Override
    public double[] read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return new ProtocolReader(protocol).readDoubleArray();
    }

    @Override
    public void write(double[] value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        new ProtocolWriter(protocol).writeDoubleArray(value);
    }
}

