/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.builtin;

import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.OptionalDouble;

@Immutable
public class OptionalDoubleThriftCodec
implements ThriftCodec<OptionalDouble> {
    @Override
    public ThriftType getType() {
        return new ThriftType(ThriftType.DOUBLE, (Type)((Object)OptionalDouble.class), OptionalDouble.empty());
    }

    @Override
    public OptionalDouble read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return OptionalDouble.of(protocol.readDouble());
    }

    @Override
    public void write(OptionalDouble value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        protocol.writeDouble(value.orElseThrow(() -> new IllegalArgumentException("value is not present")));
    }

    @Override
    public boolean isNull(OptionalDouble value) {
        return value == null || !value.isPresent();
    }
}

