/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.annotations.ThriftEnumUnknownValue;
import io.airlift.drift.annotations.ThriftEnumValue;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ThriftEnumMetadata<T extends Enum<T>> {
    private final Class<T> enumClass;
    private final Map<Integer, T> byEnumValue;
    private final Map<T, Integer> byEnumConstant;
    private final Optional<T> unknownEnumConstant;
    private final String enumName;
    private final ImmutableList<String> documentation;
    private final ImmutableMap<T, ImmutableList<String>> elementDocs;

    public ThriftEnumMetadata(String enumName, Class<T> enumClass) throws RuntimeException {
        this.enumName = Objects.requireNonNull(enumName, "enumName must not be null");
        this.enumClass = Objects.requireNonNull(enumClass, "enumClass must not be null");
        Method enumValueMethod = null;
        for (Method method : enumClass.getMethods()) {
            if (!method.isAnnotationPresent(ThriftEnumValue.class)) continue;
            Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (String)"Enum class %s @ThriftEnumValue method is not public: %s", (Object)enumClass.getName(), (Object)method);
            Preconditions.checkArgument((!Modifier.isStatic(method.getModifiers()) ? 1 : 0) != 0, (String)"Enum class %s @ThriftEnumValue method is static: %s", (Object)enumClass.getName(), (Object)method);
            Preconditions.checkArgument((method.getTypeParameters().length == 0 ? 1 : 0) != 0, (String)"Enum class %s @ThriftEnumValue method has parameters: %s", (Object)enumClass.getName(), (Object)method);
            Class<?> returnType = method.getReturnType();
            Preconditions.checkArgument((returnType == Integer.TYPE || returnType == Integer.class ? 1 : 0) != 0, (String)"Enum class %s @ThriftEnumValue method does not return int or Integer: %s", (Object)enumClass.getName(), (Object)method);
            Preconditions.checkArgument((enumValueMethod == null ? 1 : 0) != 0, (String)"Enum class %s has multiple methods annotated with @ThriftEnumValue", (Object)enumClass.getName());
            enumValueMethod = method;
        }
        Preconditions.checkArgument((enumValueMethod != null ? 1 : 0) != 0, (String)"Enum class %s must have a method annotated with @ThriftEnumValue", (Object)enumClass.getName());
        HashSet<Integer> values = new HashSet<Integer>();
        ImmutableMap.Builder elementDocs = ImmutableMap.builder();
        ImmutableMap.Builder byEnumValue = ImmutableMap.builder();
        ImmutableMap.Builder byEnumConstant = ImmutableMap.builder();
        Optional<Object> unknownEnumConstant = Optional.empty();
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            Integer value;
            try {
                value = (Integer)enumValueMethod.invoke((Object)enumConstant, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Enum class %s element %s get value method threw an exception", enumClass.getName(), enumConstant), e);
            }
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Enum class %s element %s returned null for enum value", (Object)enumClass.getName(), (Object)enumConstant);
            Preconditions.checkArgument((boolean)values.add(value), (String)"Enum class %s returned duplicate enum values: %s", (Object)enumClass.getName(), (Object)value);
            byEnumValue.put((Object)value, (Object)enumConstant);
            byEnumConstant.put((Object)enumConstant, (Object)value);
            if (ThriftEnumMetadata.isThriftEnumUnknownValue(enumClass, enumConstant)) {
                Preconditions.checkArgument((!unknownEnumConstant.isPresent() ? 1 : 0) != 0, (String)"Enum class %s has multiple constants annotated with @ThriftEnumUnknownValue", (Object)enumClass.getName());
                unknownEnumConstant = Optional.of(enumConstant);
            }
            elementDocs.put((Object)enumConstant, ThriftCatalog.getThriftDocumentation(enumConstant));
        }
        this.byEnumValue = byEnumValue.build();
        this.byEnumConstant = byEnumConstant.build();
        this.unknownEnumConstant = unknownEnumConstant;
        this.elementDocs = elementDocs.build();
        this.documentation = ThriftCatalog.getThriftDocumentation(enumClass);
    }

    private static <T extends Enum<T>> boolean isThriftEnumUnknownValue(Class<T> enumClass, T enumConstant) {
        try {
            return enumConstant.getClass().getField(enumConstant.name()).isAnnotationPresent(ThriftEnumUnknownValue.class);
        }
        catch (NoSuchFieldException ignored) {
            throw new IllegalArgumentException(String.format("Enum class %s does not have field for enum constant: %s", enumClass.getName(), enumConstant));
        }
    }

    public String getEnumName() {
        return this.enumName;
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    public Map<Integer, T> getByEnumValue() {
        return this.byEnumValue;
    }

    public Map<T, Integer> getByEnumConstant() {
        return this.byEnumConstant;
    }

    public Optional<T> getUnknownEnumConstant() {
        return this.unknownEnumConstant;
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public Map<T, ImmutableList<String>> getElementsDocumentation() {
        return this.elementDocs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftEnumMetadata that = (ThriftEnumMetadata)o;
        return Objects.equals(this.enumClass, that.enumClass);
    }

    public int hashCode() {
        return Objects.hash(this.enumClass);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enumClass", this.enumClass).add("byThriftValue", this.byEnumValue).toString();
    }
}

