/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.TException;
import io.airlift.drift.annotations.ThriftException;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftHeader;
import io.airlift.drift.annotations.ThriftId;
import io.airlift.drift.annotations.ThriftIdlAnnotation;
import io.airlift.drift.annotations.ThriftMethod;
import io.airlift.drift.annotations.ThriftRetryable;
import io.airlift.drift.annotations.ThriftStruct;
import io.airlift.drift.codec.metadata.DefaultThriftTypeReference;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftHeaderParameter;
import io.airlift.drift.codec.metadata.ThriftInjection;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import io.airlift.drift.codec.metadata.ThriftType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Immutable
public class ThriftMethodMetadata {
    private final String name;
    private final ThriftType returnType;
    private final List<ThriftFieldMetadata> parameters;
    private final Set<ThriftHeaderParameter> headerParameters;
    private final Method method;
    private final Map<Short, ExceptionInfo> exceptions;
    private final boolean oneway;
    private final boolean idempotent;
    private final List<String> documentation;

    public ThriftMethodMetadata(Method method, ThriftCatalog catalog) {
        Objects.requireNonNull(method, "method is null");
        Objects.requireNonNull(catalog, "catalog is null");
        this.method = method;
        ThriftMethod thriftMethod = method.getAnnotation(ThriftMethod.class);
        Preconditions.checkArgument((thriftMethod != null ? 1 : 0) != 0, (Object)"Method is not annotated with @ThriftMethod");
        Preconditions.checkArgument((!Modifier.isStatic(method.getModifiers()) ? 1 : 0) != 0, (String)"Method %s is static", (Object)method.toGenericString());
        this.name = thriftMethod.value().isEmpty() ? method.getName() : thriftMethod.value();
        this.returnType = catalog.getThriftType(method.getGenericReturnType());
        ImmutableList.Builder thriftParameterBuilder = ImmutableList.builder();
        ImmutableSet.Builder headerParameterBuilder = ImmutableSet.builder();
        Type[] parameterTypes = method.getGenericParameterTypes();
        List<String> parameterNames = ReflectionHelper.extractParameterNames(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        short nextThriftFieldId = 1;
        for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
            ThriftField thriftField = Stream.of(parameterAnnotations[parameterIndex]).filter(ThriftField.class::isInstance).map(ThriftField.class::cast).findAny().orElse(null);
            ThriftHeader thriftHeader = Stream.of(parameterAnnotations[parameterIndex]).filter(ThriftHeader.class::isInstance).map(ThriftHeader.class::cast).findAny().orElse(null);
            if (thriftHeader != null) {
                Preconditions.checkArgument((thriftField == null ? 1 : 0) != 0, (String)"ThriftMethod [%s] parameter %s must not be annotated with both @ThriftField and @ThriftHeader", (Object)ThriftMethodMetadata.methodName(method), (int)parameterIndex);
                Preconditions.checkArgument((parameterTypes[parameterIndex] == String.class ? 1 : 0) != 0, (String)"ThriftMethod [%s] parameter %s annotated with @ThriftHeader must be a String", (Object)ThriftMethodMetadata.methodName(method), (int)parameterIndex);
                String headerName = thriftHeader.value();
                Preconditions.checkArgument((!headerName.isEmpty() ? 1 : 0) != 0, (String)"ThriftMethod [%s] parameter %s @ThriftHeader.name must not be empty", (Object)ThriftMethodMetadata.methodName(method), (int)parameterIndex);
                headerParameterBuilder.add((Object)new ThriftHeaderParameter(parameterIndex, headerName));
                continue;
            }
            short thriftFieldId = Short.MIN_VALUE;
            boolean isLegacyId = false;
            String parameterName = null;
            ImmutableMap parameterIdlAnnotations = null;
            ThriftField.Requiredness parameterRequiredness = ThriftField.Requiredness.UNSPECIFIED;
            if (thriftField != null) {
                thriftFieldId = thriftField.value();
                isLegacyId = thriftField.isLegacyId();
                parameterRequiredness = thriftField.requiredness();
                ImmutableMap.Builder idlAnnotationsBuilder = ImmutableMap.builder();
                for (ThriftIdlAnnotation idlAnnotation : thriftField.idlAnnotations()) {
                    idlAnnotationsBuilder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
                }
                parameterIdlAnnotations = idlAnnotationsBuilder.build();
                if (!thriftField.name().isEmpty()) {
                    parameterName = thriftField.name();
                }
            }
            if (thriftFieldId == Short.MIN_VALUE) {
                thriftFieldId = nextThriftFieldId;
            }
            nextThriftFieldId = (short)(nextThriftFieldId + 1);
            if (parameterName == null) {
                parameterName = parameterNames.get(parameterIndex);
            }
            Type parameterType = parameterTypes[parameterIndex];
            ThriftType thriftType = catalog.getThriftType(parameterType);
            ThriftParameterInjection parameterInjection = new ThriftParameterInjection(thriftFieldId, parameterName, parameterIndex, parameterType);
            if (parameterRequiredness == ThriftField.Requiredness.UNSPECIFIED) {
                parameterRequiredness = ThriftField.Requiredness.NONE;
            }
            ThriftFieldMetadata fieldMetadata = new ThriftFieldMetadata(thriftFieldId, isLegacyId, false, parameterRequiredness, (Map<String, String>)parameterIdlAnnotations, new DefaultThriftTypeReference(thriftType), parameterName, FieldKind.THRIFT_FIELD, (List<ThriftInjection>)ImmutableList.of((Object)parameterInjection), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            thriftParameterBuilder.add((Object)fieldMetadata);
        }
        this.parameters = thriftParameterBuilder.build();
        this.headerParameters = headerParameterBuilder.build();
        this.exceptions = this.buildExceptionMap(catalog, thriftMethod);
        this.oneway = thriftMethod.oneway();
        this.idempotent = thriftMethod.idempotent();
        this.documentation = ThriftCatalog.getThriftDocumentation(method);
    }

    public String getName() {
        return this.name;
    }

    public ThriftType getReturnType() {
        return this.returnType;
    }

    public List<ThriftFieldMetadata> getParameters() {
        return this.parameters;
    }

    public Set<ThriftHeaderParameter> getHeaderParameters() {
        return this.headerParameters;
    }

    public Map<Short, ExceptionInfo> getExceptions() {
        return this.exceptions;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean getOneway() {
        return this.oneway;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public List<String> getDocumentation() {
        return this.documentation;
    }

    private Map<Short, ExceptionInfo> buildExceptionMap(ThriftCatalog catalog, ThriftMethod thriftMethod) {
        boolean mixedStyle = thriftMethod.exception().length > 0 && Arrays.stream(this.method.getAnnotatedExceptionTypes()).anyMatch(type -> type.isAnnotationPresent(ThriftId.class));
        Preconditions.checkArgument((!mixedStyle ? 1 : 0) != 0, (String)"ThriftMethod [%s] uses a mix of @ThriftException and @ThriftId", (Object)ThriftMethodMetadata.methodName(this.method));
        HashMap<Short, ExceptionInfo> exceptions = new HashMap<Short, ExceptionInfo>();
        HashSet exceptionTypes = new HashSet();
        for (ThriftException thriftException : thriftMethod.exception()) {
            Preconditions.checkArgument((!exceptions.containsKey(thriftException.id()) ? 1 : 0) != 0, (String)"ThriftMethod [%s] exception list contains multiple values for field ID [%s]", (Object)ThriftMethodMetadata.methodName(this.method), (int)thriftException.id());
            Preconditions.checkArgument((!exceptionTypes.contains(thriftException.type()) ? 1 : 0) != 0, (String)"ThriftMethod [%s] exception list contains multiple values for type [%s]", (Object)ThriftMethodMetadata.methodName(this.method), (Object)thriftException.type().getSimpleName());
            exceptions.put(thriftException.id(), new ExceptionInfo(catalog.getThriftType(thriftException.type()), ThriftMethodMetadata.retryable(thriftException.retryable())));
            exceptionTypes.add(thriftException.type());
        }
        Class<?>[] allExceptionClasses = this.method.getExceptionTypes();
        AnnotatedType[] exceptionAnnotations = this.method.getAnnotatedExceptionTypes();
        for (int i = 0; i < allExceptionClasses.length; ++i) {
            Class<?> exception2 = allExceptionClasses[i];
            ThriftId thriftId = exceptionAnnotations[i].getAnnotation(ThriftId.class);
            ThriftRetryable thriftRetryable = exceptionAnnotations[i].getAnnotation(ThriftRetryable.class);
            Optional<Boolean> retryable = Optional.empty();
            if (thriftRetryable != null) {
                Preconditions.checkArgument((thriftId != null ? 1 : 0) != 0, (String)"ThriftMethod [%s] exception list contains @ThriftRetryable without @ThriftId", (Object)ThriftMethodMetadata.methodName(this.method));
                retryable = Optional.of(thriftRetryable.value());
            }
            if (thriftId == null) continue;
            Preconditions.checkArgument((!exceptions.containsKey(thriftId.value()) ? 1 : 0) != 0, (String)"ThriftMethod [%s] exception list contains multiple values for field ID [%s]", (Object)ThriftMethodMetadata.methodName(this.method), (int)thriftId.value());
            Preconditions.checkArgument((!exceptionTypes.contains(exception2) ? 1 : 0) != 0, (String)"ThriftMethod [%s] exception list contains multiple values for type [%s]", (Object)ThriftMethodMetadata.methodName(this.method), (Object)exception2.getSimpleName());
            exceptions.put(thriftId.value(), new ExceptionInfo(catalog.getThriftType(exception2), retryable));
            exceptionTypes.add(exception2);
        }
        List exceptionClasses = Arrays.stream(this.method.getExceptionTypes()).filter(exception -> !exception.isAssignableFrom(TException.class)).collect(Collectors.toList());
        for (Class exceptionClass : exceptionClasses) {
            Preconditions.checkArgument((boolean)exceptionClass.isAnnotationPresent(ThriftStruct.class), (String)"ThriftMethod [%s] exception [%s] is not annotated with @ThriftStruct", (Object)ThriftMethodMetadata.methodName(this.method), (Object)exceptionClass.getSimpleName());
            if (exceptionTypes.contains(exceptionClass)) continue;
            Preconditions.checkArgument((exceptionClasses.size() == 1 ? 1 : 0) != 0, (String)"ThriftMethod [%s] annotation must declare exception mapping when more than one custom exception is thrown", (Object)ThriftMethodMetadata.methodName(this.method));
            exceptions.put((short)1, new ExceptionInfo(catalog.getThriftType(exceptionClass), Optional.empty()));
        }
        return ImmutableMap.copyOf(exceptions);
    }

    public boolean isAsync() {
        Type returnType = this.method.getGenericReturnType();
        Class rawType = TypeToken.of((Type)returnType).getRawType();
        return ListenableFuture.class.isAssignableFrom(rawType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftMethodMetadata that = (ThriftMethodMetadata)o;
        return this.oneway == that.oneway && Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.headerParameters, that.headerParameters) && Objects.equals(this.method, that.method) && Objects.equals(this.exceptions, that.exceptions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.parameters, this.headerParameters, this.method, this.exceptions, this.oneway);
    }

    private static String methodName(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    private static Optional<Boolean> retryable(ThriftException.Retryable retryable) {
        switch (retryable) {
            case UNKNOWN: {
                return Optional.empty();
            }
            case FALSE: {
                return Optional.of(false);
            }
            case TRUE: {
                return Optional.of(true);
            }
        }
        throw new AssertionError((Object)("Unhandled value: " + String.valueOf(retryable)));
    }

    public static class ExceptionInfo {
        private final ThriftType thriftType;
        private final Optional<Boolean> retryable;

        public ExceptionInfo(ThriftType thriftType, Optional<Boolean> retryable) {
            this.thriftType = Objects.requireNonNull(thriftType, "thriftType is null");
            this.retryable = Objects.requireNonNull(retryable, "retryable is null");
        }

        public ThriftType getThriftType() {
            return this.thriftType;
        }

        public Optional<Boolean> isRetryable() {
            return this.retryable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExceptionInfo that = (ExceptionInfo)o;
            return this.thriftType.equals(that.thriftType) && this.retryable.equals(that.retryable);
        }

        public int hashCode() {
            return Objects.hash(this.thriftType, this.retryable);
        }
    }
}

