/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ThriftInjection;
import java.lang.reflect.Type;
import java.util.Objects;

@Immutable
public class ThriftParameterInjection
implements ThriftInjection {
    private final short id;
    private final String name;
    private final int parameterIndex;
    private final Type javaType;

    public ThriftParameterInjection(short id, String name, int parameterIndex, Type javaType) {
        Preconditions.checkArgument((parameterIndex >= 0 ? 1 : 0) != 0, (Object)"parameterIndex is negative");
        this.javaType = Objects.requireNonNull(javaType, "javaType is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.id = id;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FieldKind getFieldKind() {
        return FieldKind.THRIFT_FIELD;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (int)this.id).add("name", (Object)this.name).add("parameterIndex", this.parameterIndex).add("javaType", (Object)this.javaType).toString();
    }
}

