/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.server;

import com.google.common.collect.ImmutableList;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.server.DriftServerMethodInvoker;
import io.airlift.drift.server.DriftService;
import io.airlift.drift.server.MethodInvocationFilter;
import io.airlift.drift.server.stats.MethodInvocationStatsFactory;
import io.airlift.drift.transport.server.ServerMethodInvoker;
import io.airlift.drift.transport.server.ServerTransport;
import io.airlift.drift.transport.server.ServerTransportFactory;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class DriftServer {
    private final ServerTransport serverTransport;

    @Inject
    public DriftServer(ServerTransportFactory serverTransportFactory, ThriftCodecManager codecManager, MethodInvocationStatsFactory methodInvocationStatsFactory, Set<DriftService> services, Set<MethodInvocationFilter> filters) {
        Objects.requireNonNull(serverTransportFactory, "serverTransportFactory is null");
        Objects.requireNonNull(codecManager, "codecManager is null");
        Objects.requireNonNull(services, "services is null");
        DriftServerMethodInvoker methodInvoker = new DriftServerMethodInvoker(codecManager, services, (List<MethodInvocationFilter>)ImmutableList.copyOf(filters), methodInvocationStatsFactory);
        this.serverTransport = serverTransportFactory.createServerTransport((ServerMethodInvoker)methodInvoker);
    }

    public ServerTransport getServerTransport() {
        return this.serverTransport;
    }

    @PostConstruct
    public void start() {
        this.serverTransport.start();
    }

    @PreDestroy
    public void shutdown() {
        this.serverTransport.shutdown();
    }
}

