/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.server;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftHeaderParameter;
import io.airlift.drift.codec.metadata.ThriftInjection;
import io.airlift.drift.codec.metadata.ThriftMethodMetadata;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import io.airlift.drift.server.FilteredMethodInvoker;
import io.airlift.drift.server.MethodInvocationFilter;
import io.airlift.drift.server.ServerMethodInvoker;
import io.airlift.drift.transport.MethodMetadata;
import io.airlift.drift.transport.server.ServerInvokeRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class ServiceMethod {
    private final Object service;
    private final MethodMetadata methodMetadata;
    private final ServerMethodInvoker invoker;

    public ServiceMethod(ThriftCodecManager codecManager, Object service, ThriftMethodMetadata methodMetadata, List<MethodInvocationFilter> filters) {
        Objects.requireNonNull(codecManager, "codecManager is null");
        Objects.requireNonNull(service, "service is null");
        Objects.requireNonNull(methodMetadata, "methodMetadata is null");
        this.service = service;
        this.methodMetadata = MethodMetadata.toMethodMetadata((ThriftCodecManager)codecManager, (ThriftMethodMetadata)methodMetadata);
        this.invoker = FilteredMethodInvoker.createFilteredMethodInvoker(filters, new ServiceMethodInvoker(service, methodMetadata));
    }

    public MethodMetadata getMethodMetadata() {
        return this.methodMetadata;
    }

    public ListenableFuture<Object> invokeMethod(ServerInvokeRequest request) {
        return this.invoker.invoke(request);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("methodMetadata", (Object)this.methodMetadata).add("service", this.service).toString();
    }

    private static class ServiceMethodInvoker
    implements ServerMethodInvoker {
        private final Object service;
        private final Method method;
        private final ThriftHeaderParameter[] headerParameters;
        private final ThriftFieldMetadata[] normalParameters;

        public ServiceMethodInvoker(Object service, ThriftMethodMetadata methodMetadata) {
            this.service = Objects.requireNonNull(service, "service is null");
            this.method = Objects.requireNonNull(methodMetadata.getMethod(), "method is null");
            this.headerParameters = new ThriftHeaderParameter[this.method.getParameterCount()];
            Iterator iterator = methodMetadata.getHeaderParameters().iterator();
            while (iterator.hasNext()) {
                ThriftHeaderParameter headerParameter;
                this.headerParameters[headerParameter.getIndex()] = headerParameter = (ThriftHeaderParameter)iterator.next();
            }
            this.normalParameters = new ThriftFieldMetadata[this.method.getParameterCount()];
            for (ThriftFieldMetadata normalParameter : methodMetadata.getParameters()) {
                for (ThriftInjection thriftInjection : normalParameter.getInjections()) {
                    ThriftParameterInjection parameterInjection = (ThriftParameterInjection)thriftInjection;
                    this.normalParameters[parameterInjection.getParameterIndex()] = normalParameter;
                }
            }
        }

        @Override
        public ListenableFuture<Object> invoke(ServerInvokeRequest request) {
            Object[] parameters = new Object[this.method.getParameterCount()];
            for (int i = 0; i < this.headerParameters.length; ++i) {
                ThriftFieldMetadata normalParameter;
                ThriftHeaderParameter headerParameter = this.headerParameters[i];
                if (headerParameter != null) {
                    parameters[i] = request.getHeaders().get(headerParameter.getName());
                }
                if ((normalParameter = this.normalParameters[i]) == null) continue;
                parameters[i] = request.getParameters().get(normalParameter.getId());
            }
            try {
                Object response = this.method.invoke(this.service, parameters);
                if (response instanceof ListenableFuture) {
                    return (ListenableFuture)response;
                }
                return Futures.immediateFuture((Object)response);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    return Futures.immediateFailedFuture((Throwable)cause);
                }
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
    }
}

