/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.drift.TApplicationException;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.metadata.ThriftMethodMetadata;
import io.airlift.drift.codec.metadata.ThriftServiceMetadata;
import io.airlift.drift.server.DriftService;
import io.airlift.drift.server.MethodInvocationFilter;
import io.airlift.drift.server.ServiceMethod;
import io.airlift.drift.server.stats.MethodInvocationStat;
import io.airlift.drift.server.stats.MethodInvocationStatsFactory;
import io.airlift.drift.transport.MethodMetadata;
import io.airlift.drift.transport.server.ServerInvokeRequest;
import io.airlift.drift.transport.server.ServerMethodInvoker;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class DriftServerMethodInvoker
implements ServerMethodInvoker {
    private final Map<String, ServiceMethod> methods;
    private final Map<String, MethodInvocationStat> stats;

    public DriftServerMethodInvoker(ThriftCodecManager codecManager, Collection<DriftService> services, List<MethodInvocationFilter> filters, MethodInvocationStatsFactory methodInvocationStatsFactory) {
        HashMap<String, ServiceMethod> processorMap = new HashMap<String, ServiceMethod>();
        ImmutableMap.Builder stats = ImmutableMap.builder();
        for (DriftService service : services) {
            ThriftServiceMetadata serviceMetadata = new ThriftServiceMetadata(service.getService().getClass(), codecManager.getCatalog());
            for (ThriftMethodMetadata thriftMethodMetadata : serviceMetadata.getMethods().values()) {
                if (processorMap.containsKey(thriftMethodMetadata.getName())) {
                    throw new IllegalArgumentException(String.format("Multiple methods named '%s' are annotated with @ThriftMethod in the given services", thriftMethodMetadata.getName()));
                }
                ServiceMethod serviceMethod = new ServiceMethod(codecManager, service.getService(), thriftMethodMetadata, filters);
                processorMap.put(thriftMethodMetadata.getName(), serviceMethod);
                if (!service.isStatsEnabled()) continue;
                stats.put((Object)thriftMethodMetadata.getName(), (Object)methodInvocationStatsFactory.getStat(serviceMetadata, service.getQualifier(), serviceMethod.getMethodMetadata()));
            }
        }
        this.methods = ImmutableMap.copyOf(processorMap);
        this.stats = stats.build();
    }

    public Optional<MethodMetadata> getMethodMetadata(String name) {
        ServiceMethod method = this.methods.get(name);
        if (method == null) {
            return Optional.empty();
        }
        return Optional.of(method.getMethodMetadata());
    }

    public ListenableFuture<Object> invoke(ServerInvokeRequest request) {
        ServiceMethod method = this.methods.get(request.getMethod().getName());
        if (method == null) {
            return Futures.immediateFailedFuture((Throwable)new TApplicationException(TApplicationException.Type.UNKNOWN_METHOD, "Invalid method name: '" + request.getMethod().getName() + "'"));
        }
        return method.invokeMethod(request);
    }

    public void recordResult(String methodName, long startTime, ListenableFuture<Object> result) {
        MethodInvocationStat stat = this.stats.get(methodName);
        if (stat == null) {
            return;
        }
        stat.recordResult(startTime, result);
    }
}

