/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.server.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.airlift.drift.codec.guice.ThriftCodecModule;
import io.airlift.drift.codec.metadata.ThriftServiceMetadata;
import io.airlift.drift.server.DriftServer;
import io.airlift.drift.server.DriftService;
import io.airlift.drift.server.MethodInvocationFilter;
import io.airlift.drift.server.guice.DefaultService;
import io.airlift.drift.server.stats.JmxMethodInvocationStatsFactory;
import io.airlift.drift.server.stats.MethodInvocationStatsFactory;
import io.airlift.drift.server.stats.NullMethodInvocationStatsFactory;
import io.airlift.drift.transport.server.DriftServerConfig;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.weakref.jmx.MBeanExporter;

public class DriftServerBinder {
    private final Binder binder;

    public static DriftServerBinder driftServerBinder(Binder binder) {
        return new DriftServerBinder(binder);
    }

    private DriftServerBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        binder.install((Module)new ThriftCodecModule());
        binder.install((Module)new DriftServerBinderModule());
    }

    public <T> void bindService(Class<T> serverInterface) {
        this.bindService(serverInterface, DriftServerBinder.getServiceName(serverInterface), DefaultService.class);
    }

    public <T> void bindService(Class<T> serverInterface, Class<? extends Annotation> annotationType) {
        String configPrefix = DriftServerBinder.getServiceName(serverInterface) + "." + annotationType.getSimpleName();
        this.bindService(serverInterface, configPrefix, annotationType);
    }

    private <T> void bindService(Class<T> serverInterface, String configPrefix, Class<? extends Annotation> annotation) {
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(DriftServerConfig.class, annotation, configPrefix);
        Multibinder.newSetBinder((Binder)this.binder, DriftService.class).addBinding().toProvider(new DriftServiceProvider<T>(serverInterface, annotation)).in(Scopes.SINGLETON);
        if (annotation == DefaultService.class) {
            this.binder.bind(serverInterface).annotatedWith(DefaultService.class).to(serverInterface);
        }
    }

    public void bindFilter(MethodInvocationFilter filter) {
        Multibinder.newSetBinder((Binder)this.binder, MethodInvocationFilter.class).addBinding().toInstance((Object)filter);
    }

    public <T extends MethodInvocationFilter> void bindFilter(Class<T> filterClass) {
        Multibinder.newSetBinder((Binder)this.binder, MethodInvocationFilter.class).addBinding().to(filterClass);
    }

    public <T extends MethodInvocationFilter> void bindFilter(Key<T> filterKey) {
        Multibinder.newSetBinder((Binder)this.binder, MethodInvocationFilter.class).addBinding().to(filterKey);
    }

    private static String getServiceName(Class<?> serverInterface) {
        Objects.requireNonNull(serverInterface, "serverInterface is null");
        String serviceName = ThriftServiceMetadata.getThriftServiceAnnotation(serverInterface).value();
        if (!serviceName.isEmpty()) {
            return serviceName;
        }
        return serverInterface.getSimpleName();
    }

    private static class DriftServerBinderModule
    implements Module {
        private DriftServerBinderModule() {
        }

        public void configure(Binder binder) {
            binder.bind(DriftServer.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, DriftService.class);
            Multibinder.newSetBinder((Binder)binder, MethodInvocationFilter.class);
            OptionalBinder.newOptionalBinder((Binder)binder, MBeanExporter.class);
            OptionalBinder.newOptionalBinder((Binder)binder, MethodInvocationStatsFactory.class).setDefault().toProvider(DefaultMethodInvocationStatsFactoryProvider.class).in(Scopes.SINGLETON);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 42;
        }
    }

    private static class DriftServiceProvider<T>
    implements Provider<DriftService> {
        private final Class<T> serverInterface;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        public DriftServiceProvider(Class<T> serverInterface, Class<? extends Annotation> annotation) {
            this.serverInterface = Objects.requireNonNull(serverInterface, "serverInterface is null");
            this.annotation = Objects.requireNonNull(annotation, "annotation is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public final DriftService get() {
            Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"injector was not set");
            Object service = this.injector.getInstance(Key.get(this.serverInterface, this.annotation));
            DriftServerConfig config = (DriftServerConfig)this.injector.getInstance(Key.get(DriftServerConfig.class, this.annotation));
            Optional<Object> qualifier = this.annotation == DefaultService.class ? Optional.empty() : Optional.of(this.annotation.getSimpleName());
            return new DriftService(service, qualifier, config.isStatsEnabled());
        }
    }

    private static class DefaultMethodInvocationStatsFactoryProvider
    implements Provider<MethodInvocationStatsFactory> {
        private final Optional<MBeanExporter> mbeanExporter;

        @Inject
        public DefaultMethodInvocationStatsFactoryProvider(Optional<MBeanExporter> mbeanExporter) {
            this.mbeanExporter = mbeanExporter;
        }

        public MethodInvocationStatsFactory get() {
            return this.mbeanExporter.map(JmxMethodInvocationStatsFactory::new).map(MethodInvocationStatsFactory.class::cast).orElseGet(NullMethodInvocationStatsFactory::new);
        }
    }
}

