/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.net.HostAndPort;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.Transport;
import io.airlift.drift.transport.netty.ssl.SslContextFactory;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;

interface ConnectionManager
extends Closeable {
    public Future<Channel> getConnection(ConnectionParameters var1, HostAndPort var2);

    public void returnConnection(Channel var1);

    @Override
    public void close();

    public static class ConnectionParameters {
        private final Transport transport;
        private final Protocol protocol;
        private final DataSize maxFrameSize;
        private final Duration connectTimeout;
        private final Duration requestTimeout;
        private final Optional<HostAndPort> socksProxy;
        private final Optional<SslContextFactory.SslContextParameters> sslContextParameters;

        public ConnectionParameters(Transport transport, Protocol protocol, DataSize maxFrameSize, Duration connectTimeout, Duration requestTimeout, Optional<HostAndPort> socksProxy, Optional<SslContextFactory.SslContextParameters> sslContextParameters) {
            this.transport = Objects.requireNonNull(transport, "transport is null");
            this.protocol = Objects.requireNonNull(protocol, "protocol is null");
            this.maxFrameSize = Objects.requireNonNull(maxFrameSize, "maxFrameSize is null");
            this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout is null");
            this.requestTimeout = Objects.requireNonNull(requestTimeout, "requestTimeout is null");
            this.socksProxy = Objects.requireNonNull(socksProxy, "socksProxy is null");
            this.sslContextParameters = Objects.requireNonNull(sslContextParameters, "sslContextParameters is null");
        }

        public Transport getTransport() {
            return this.transport;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public DataSize getMaxFrameSize() {
            return this.maxFrameSize;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public Optional<HostAndPort> getSocksProxy() {
            return this.socksProxy;
        }

        public Optional<SslContextFactory.SslContextParameters> getSslContextParameters() {
            return this.sslContextParameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionParameters that = (ConnectionParameters)o;
            return this.transport == that.transport && this.protocol == that.protocol && Objects.equals(this.maxFrameSize, that.maxFrameSize) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.socksProxy, that.socksProxy) && Objects.equals(this.sslContextParameters, that.sslContextParameters);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.transport, this.protocol, this.maxFrameSize, this.connectTimeout, this.requestTimeout, this.socksProxy, this.sslContextParameters});
        }
    }
}

