/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.drift.protocol.TTransportException;
import io.airlift.drift.transport.netty.client.ConnectionManager;
import io.airlift.drift.transport.netty.client.DriftNettyClientConfig;
import io.airlift.drift.transport.netty.client.ThriftClientInitializer;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.Transport;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

class ConnectionFactory
implements ConnectionManager {
    private final EventLoopGroup group;
    private final Transport transport;
    private final Protocol protocol;
    private final DataSize maxFrameSize;
    private final Optional<Supplier<SslContext>> sslContextSupplier;
    private final Duration connectTimeout;
    private final Duration requestTimeout;
    private final Optional<HostAndPort> socksProxy;

    ConnectionFactory(EventLoopGroup group, Transport transport, Protocol protocol, DataSize maxFrameSize, Optional<Supplier<SslContext>> sslContextSupplier, DriftNettyClientConfig clientConfig) {
        this.group = Objects.requireNonNull(group, "group is null");
        this.transport = Objects.requireNonNull(transport, "transport is null");
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
        this.maxFrameSize = Objects.requireNonNull(maxFrameSize, "maxFrameSize is null");
        this.sslContextSupplier = Objects.requireNonNull(sslContextSupplier, "sslContextSupplier is null");
        Objects.requireNonNull(clientConfig, "clientConfig is null");
        this.connectTimeout = clientConfig.getConnectTimeout();
        this.requestTimeout = clientConfig.getRequestTimeout();
        this.socksProxy = Optional.ofNullable(clientConfig.getSocksProxy());
    }

    @Override
    public Future<Channel> getConnection(HostAndPort address) {
        try {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Ints.saturatedCast((long)this.connectTimeout.toMillis()))).handler((ChannelHandler)new ThriftClientInitializer(this.transport, this.protocol, this.maxFrameSize, this.requestTimeout, this.socksProxy, this.sslContextSupplier));
            Promise promise = this.group.next().newPromise();
            bootstrap.connect((SocketAddress)new InetSocketAddress(address.getHost(), address.getPort())).addListener((GenericFutureListener)((ChannelFutureListener)future -> ConnectionFactory.notifyConnect(future, (Promise<Channel>)promise)));
            return promise;
        }
        catch (Throwable e) {
            return this.group.next().newFailedFuture((Throwable)new TTransportException(e));
        }
    }

    private static void notifyConnect(ChannelFuture future, Promise<Channel> promise) {
        if (future.isSuccess()) {
            Channel channel = future.channel();
            if (!promise.trySuccess((Object)channel)) {
                channel.close();
            }
        } else {
            promise.tryFailure(future.cause());
        }
    }

    @Override
    public void returnConnection(Channel connection) {
        connection.close();
    }
}

