/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.drift.protocol.TTransportException;
import io.airlift.drift.transport.netty.client.ConnectionManager;
import io.airlift.drift.transport.netty.client.DriftNettyClientConfig;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

class ConnectionPool
implements ConnectionManager,
Closeable {
    private final ConnectionManager connectionFactory;
    private final EventLoopGroup group;
    private final LoadingCache<HostAndPort, Future<Channel>> cachedConnections;
    private final ScheduledExecutorService maintenanceThread;
    @GuardedBy(value="this")
    private boolean closed;

    public ConnectionPool(ConnectionManager connectionFactory, EventLoopGroup group, DriftNettyClientConfig config) {
        this.connectionFactory = connectionFactory;
        this.group = Objects.requireNonNull(group, "group is null");
        Objects.requireNonNull(config, "config is null");
        this.cachedConnections = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).removalListener(notification -> ConnectionPool.closeConnection((Future<Channel>)((Future)notification.getValue()))).build((CacheLoader)new CacheLoader<HostAndPort, Future<Channel>>(){

            public Future<Channel> load(HostAndPort address) throws Exception {
                return ConnectionPool.this.createConnection(address);
            }
        });
        this.maintenanceThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("drift-connection-maintenance-%s").setDaemon(true).build());
        this.maintenanceThread.scheduleWithFixedDelay(() -> this.cachedConnections.cleanUp(), 1L, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Channel> getConnection(HostAndPort address) {
        Future future;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.closed) {
                return this.group.next().newFailedFuture((Throwable)new TTransportException("Connection pool is closed"));
            }
            try {
                future = (Future)this.cachedConnections.get((Object)address);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        if (ConnectionPool.isFailed(future)) {
            this.cachedConnections.asMap().remove(address, future);
        }
        return future;
    }

    @Override
    public void returnConnection(Channel connection) {
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.cachedConnections.invalidateAll();
        }
        finally {
            this.maintenanceThread.shutdownNow();
        }
    }

    private Future<Channel> createConnection(HostAndPort address) {
        return this.connectionFactory.getConnection(address);
    }

    private static void closeConnection(Future<Channel> future) {
        future.addListener(ignored -> {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                channel.close();
            }
        });
    }

    private static boolean isFailed(Future<?> future) {
        if (!future.isDone()) {
            return false;
        }
        try {
            future.get();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

