/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.ConfigBinder;
import io.airlift.drift.transport.client.DriftClientConfig;
import io.airlift.drift.transport.client.MethodInvokerFactory;
import io.airlift.drift.transport.netty.client.DriftNettyClientConfig;
import io.airlift.drift.transport.netty.client.DriftNettyConnectionFactoryConfig;
import io.airlift.drift.transport.netty.client.DriftNettyMethodInvokerFactory;
import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;

public class DriftNettyClientModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(DriftNettyConnectionFactoryConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigurationBindingListener((binding, configBinder) -> {
            if (binding.getConfigClass().equals(DriftClientConfig.class)) {
                configBinder.bindConfig(DriftNettyClientConfig.class, binding.getKey().getAnnotation(), (String)binding.getPrefix().orElse(null));
            }
        });
        binder.bind((TypeLiteral)new TypeLiteral<MethodInvokerFactory<Annotation>>(){}).toProvider(MethodInvokerFactoryProvider.class).in(Scopes.SINGLETON);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static class MethodInvokerFactoryProvider
    implements Provider<MethodInvokerFactory<Annotation>> {
        private Injector injector;
        private DriftNettyMethodInvokerFactory<Annotation> factory;

        private MethodInvokerFactoryProvider() {
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public MethodInvokerFactory<Annotation> get() {
            Preconditions.checkState((this.factory == null ? 1 : 0) != 0, (Object)"factory already created");
            this.factory = new DriftNettyMethodInvokerFactory<Annotation>((DriftNettyConnectionFactoryConfig)this.injector.getInstance(DriftNettyConnectionFactoryConfig.class), annotation -> (DriftNettyClientConfig)this.injector.getInstance(Key.get(DriftNettyClientConfig.class, (Annotation)annotation)));
            return this.factory;
        }

        @PreDestroy
        public void destroy() {
            this.factory.close();
        }
    }
}

