/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;

public class DriftNettyConnectionFactoryConfig {
    private static final int DEFAULT_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private int threadCount = DEFAULT_THREAD_COUNT;
    private Duration sslContextRefreshTime = new Duration(1.0, TimeUnit.MINUTES);
    private HostAndPort socksProxy;

    public int getThreadCount() {
        return this.threadCount;
    }

    @Config(value="thrift.client.thread-count")
    public DriftNettyConnectionFactoryConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getSslContextRefreshTime() {
        return this.sslContextRefreshTime;
    }

    @Config(value="thrift.client.ssl-context.refresh-time")
    public DriftNettyConnectionFactoryConfig setSslContextRefreshTime(Duration sslContextRefreshTime) {
        this.sslContextRefreshTime = sslContextRefreshTime;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="thrift.client.socks-proxy")
    public DriftNettyConnectionFactoryConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }
}

