/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.drift.transport.client.InvokeRequest;
import io.airlift.drift.transport.client.MethodInvoker;
import io.airlift.drift.transport.client.RequestTimeoutException;
import io.airlift.drift.transport.netty.client.ConnectionManager;
import io.airlift.drift.transport.netty.client.InvocationResponseFuture;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class DriftNettyMethodInvoker
implements MethodInvoker {
    private static final Logger log = Logger.get(DriftNettyMethodInvoker.class);
    private final ConnectionManager connectionManager;
    private final ListeningScheduledExecutorService delayService;
    private final Duration invokeTimeout;

    public DriftNettyMethodInvoker(ConnectionManager connectionManager, ScheduledExecutorService delayService, Duration invokeTimeout) {
        this.connectionManager = Objects.requireNonNull(connectionManager, "connectionManager is null");
        this.delayService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Objects.requireNonNull(delayService, "delayService is null"));
        this.invokeTimeout = Objects.requireNonNull(invokeTimeout, "invokeTimeout is null");
    }

    public ListenableFuture<Object> invoke(InvokeRequest request) {
        try {
            return MoreFutures.addTimeout((ListenableFuture)InvocationResponseFuture.createInvocationResponseFuture(request, this.connectionManager), () -> {
                String message = "Invocation response future did not complete after " + this.invokeTimeout;
                log.error(message);
                throw new RequestTimeoutException(message);
            }, (Duration)this.invokeTimeout, (ScheduledExecutorService)this.delayService);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<?> delay(Duration duration) {
        return this.delayService.schedule(() -> null, duration.toMillis(), TimeUnit.MILLISECONDS);
    }
}

