/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.drift.transport.client.MethodInvoker;
import io.airlift.drift.transport.client.MethodInvokerFactory;
import io.airlift.drift.transport.netty.client.ConnectionFactory;
import io.airlift.drift.transport.netty.client.ConnectionManager;
import io.airlift.drift.transport.netty.client.ConnectionPool;
import io.airlift.drift.transport.netty.client.DriftNettyClientConfig;
import io.airlift.drift.transport.netty.client.DriftNettyConnectionFactoryConfig;
import io.airlift.drift.transport.netty.client.DriftNettyMethodInvoker;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.Transport;
import io.airlift.drift.transport.netty.ssl.SslContextFactory;
import io.airlift.units.Duration;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class DriftNettyMethodInvokerFactory<I>
implements MethodInvokerFactory<I>,
Closeable {
    private final Function<I, DriftNettyClientConfig> clientConfigurationProvider;
    private final EventLoopGroup group;
    private final SslContextFactory sslContextFactory;
    private final HostAndPort defaultSocksProxy;

    public static DriftNettyMethodInvokerFactory<?> createStaticDriftNettyMethodInvokerFactory(DriftNettyClientConfig clientConfig) {
        return new DriftNettyMethodInvokerFactory<Object>(new DriftNettyConnectionFactoryConfig(), clientIdentity -> clientConfig);
    }

    @Inject
    public DriftNettyMethodInvokerFactory(DriftNettyConnectionFactoryConfig factoryConfig, Function<I, DriftNettyClientConfig> clientConfigurationProvider) {
        Objects.requireNonNull(factoryConfig, "factoryConfig is null");
        this.group = new NioEventLoopGroup(factoryConfig.getThreadCount(), new ThreadFactoryBuilder().setNameFormat("drift-client-%s").setDaemon(true).build());
        this.clientConfigurationProvider = Objects.requireNonNull(clientConfigurationProvider, "clientConfigurationProvider is null");
        this.sslContextFactory = SslContextFactory.createSslContextFactory(true, factoryConfig.getSslContextRefreshTime(), (ScheduledExecutorService)this.group);
        this.defaultSocksProxy = factoryConfig.getSocksProxy();
    }

    public MethodInvoker createMethodInvoker(I clientIdentity) {
        DriftNettyClientConfig clientConfig = this.clientConfigurationProvider.apply(clientIdentity);
        if (clientConfig.getTransport() == Transport.HEADER && clientConfig.getProtocol() == Protocol.COMPACT) {
            throw new IllegalArgumentException("HEADER transport cannot be used with COMPACT protocol, use FB_COMPACT instead");
        }
        if (clientConfig.getSocksProxy() == null) {
            clientConfig.setSocksProxy(this.defaultSocksProxy);
        }
        Optional<Supplier<SslContext>> sslContext = Optional.empty();
        if (clientConfig.isSslEnabled()) {
            sslContext = Optional.of(this.sslContextFactory.get(clientConfig.getTrustCertificate(), Optional.ofNullable(clientConfig.getKey()), Optional.ofNullable(clientConfig.getKey()), Optional.ofNullable(clientConfig.getKeyPassword()), clientConfig.getSessionCacheSize(), clientConfig.getSessionTimeout(), clientConfig.getCiphers()));
            sslContext.get().get();
        }
        ConnectionManager connectionManager = new ConnectionFactory(this.group, clientConfig.getTransport(), clientConfig.getProtocol(), clientConfig.getMaxFrameSize(), sslContext, clientConfig);
        if (clientConfig.isPoolEnabled()) {
            connectionManager = new ConnectionPool(connectionManager, this.group, clientConfig);
        }
        Duration invokeTimeout = new Duration((double)(TimeUnit.SECONDS.toMillis(10L) + clientConfig.getConnectTimeout().toMillis() + clientConfig.getRequestTimeout().toMillis()), TimeUnit.MILLISECONDS);
        return new DriftNettyMethodInvoker(connectionManager, (ScheduledExecutorService)this.group, invokeTimeout);
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.group.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

