/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import java.util.List;

public class OptionalSslHandler
extends ByteToMessageDecoder {
    private static final int SSL_CONTENT_TYPE_CHANGE_CIPHER_SPEC = 20;
    private static final int SSL_CONTENT_TYPE_ALERT = 21;
    private static final int SSL_CONTENT_TYPE_HANDSHAKE = 22;
    private static final int SSL_CONTENT_TYPE_APPLICATION_DATA = 23;
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    private final SslContext sslContext;

    public OptionalSslHandler(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        ChannelPipeline pipeline = context.pipeline();
        if (OptionalSslHandler.isTls(in, in.readerIndex())) {
            pipeline.replace((ChannelHandler)this, "ssl", (ChannelHandler)this.sslContext.newHandler(context.alloc()));
        } else {
            pipeline.remove((ChannelHandler)this);
        }
    }

    private static boolean isTls(ByteBuf buffer, int offset) {
        short contentType = buffer.getUnsignedByte(offset);
        if (contentType != 20 && contentType != 21 && contentType != 22 && contentType != 23) {
            return false;
        }
        short majorVersion = buffer.getUnsignedByte(offset + 1);
        if (majorVersion != 3) {
            return false;
        }
        return buffer.getUnsignedShort(offset + 3) > 0;
    }
}

