/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.server;

import com.google.common.base.Defaults;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.drift.TApplicationException;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.internal.ProtocolReader;
import io.airlift.drift.codec.internal.ProtocolWriter;
import io.airlift.drift.protocol.TMessage;
import io.airlift.drift.protocol.TProtocol;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import io.airlift.drift.protocol.TTransport;
import io.airlift.drift.transport.MethodMetadata;
import io.airlift.drift.transport.ParameterMetadata;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.ThriftFrame;
import io.airlift.drift.transport.netty.codec.Transport;
import io.airlift.drift.transport.netty.server.ExceptionWriter;
import io.airlift.drift.transport.netty.ssl.TChannelBufferInputTransport;
import io.airlift.drift.transport.netty.ssl.TChannelBufferOutputTransport;
import io.airlift.drift.transport.server.ServerInvokeRequest;
import io.airlift.drift.transport.server.ServerMethodInvoker;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ThriftServerHandler
extends ChannelDuplexHandler {
    private static final Logger log = Logger.get(ThriftServerHandler.class);
    private final ServerMethodInvoker methodInvoker;
    private final ScheduledExecutorService timeoutExecutor;
    private final Duration requestTimeout;

    public ThriftServerHandler(ServerMethodInvoker methodInvoker, Duration requestTimeout, ScheduledExecutorService timeoutExecutor) {
        this.methodInvoker = Objects.requireNonNull(methodInvoker, "methodInvoker is null");
        this.requestTimeout = Objects.requireNonNull(requestTimeout, "requestTimeout is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        if (message instanceof ThriftFrame) {
            this.messageReceived(context, (ThriftFrame)message);
            return;
        }
        context.fireChannelRead(message);
    }

    private void messageReceived(final ChannelHandlerContext context, ThriftFrame frame) {
        TChannelBufferInputTransport inputTransport = new TChannelBufferInputTransport(frame.getMessage());
        try {
            ListenableFuture<ThriftFrame> response = this.decodeMessage(context, inputTransport, frame.getTransport(), frame.getProtocol(), frame.getHeaders(), frame.isSupportOutOfOrderResponse());
            Futures.addCallback(response, (FutureCallback)new FutureCallback<ThriftFrame>(){

                public void onSuccess(ThriftFrame result) {
                    context.writeAndFlush((Object)result);
                }

                public void onFailure(Throwable t) {
                    context.disconnect();
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception processing request");
            context.disconnect();
        }
        catch (Throwable e) {
            log.error(e, "Error processing request");
            context.disconnect();
            throw e;
        }
        finally {
            inputTransport.release();
            frame.release();
        }
    }

    private ListenableFuture<ThriftFrame> decodeMessage(ChannelHandlerContext context, TTransport messageData, Transport transport, Protocol protocol, Map<String, String> headers, boolean supportOutOfOrderResponse) throws Exception {
        long start = System.nanoTime();
        TProtocol protocolReader = protocol.createProtocol(messageData);
        TMessage message = protocolReader.readMessageBegin();
        Optional methodMetadata = this.methodInvoker.getMethodMetadata(message.getName());
        if (!methodMetadata.isPresent()) {
            return Futures.immediateFuture((Object)ThriftServerHandler.writeApplicationException(context, message.getName(), transport, protocol, message.getSequenceId(), supportOutOfOrderResponse, TApplicationException.Type.UNKNOWN_METHOD, "Invalid method name: '" + message.getName() + "'", null));
        }
        MethodMetadata method = (MethodMetadata)methodMetadata.get();
        if (message.getType() != 1 && message.getType() != 4) {
            return Futures.immediateFuture((Object)ThriftServerHandler.writeApplicationException(context, message.getName(), transport, protocol, message.getSequenceId(), supportOutOfOrderResponse, TApplicationException.Type.INVALID_MESSAGE_TYPE, "Invalid method message type: '" + message.getType() + "'", null));
        }
        Map<Short, Object> parameters = ThriftServerHandler.readArguments(method, (TProtocolReader)protocolReader);
        ListenableFuture result = this.methodInvoker.invoke(new ServerInvokeRequest(method, headers, parameters));
        this.methodInvoker.recordResult(message.getName(), start, result);
        ListenableFuture encodedResult = Futures.transformAsync((ListenableFuture)result, value -> {
            try {
                return Futures.immediateFuture((Object)ThriftServerHandler.writeSuccessResponse(context, method, transport, protocol, message.getSequenceId(), supportOutOfOrderResponse, value));
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        });
        encodedResult = Futures.withTimeout((ListenableFuture)encodedResult, (long)this.requestTimeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.timeoutExecutor);
        encodedResult = Futures.catchingAsync((ListenableFuture)encodedResult, Exception.class, exception -> {
            try {
                return Futures.immediateFuture((Object)ThriftServerHandler.writeExceptionResponse(context, method, transport, protocol, message.getSequenceId(), supportOutOfOrderResponse, exception));
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        });
        return encodedResult;
    }

    private static Map<Short, Object> readArguments(MethodMetadata method, TProtocolReader protocol) throws Exception {
        HashMap<Short, Object> arguments = new HashMap<Short, Object>(method.getParameters().size());
        ProtocolReader reader = new ProtocolReader(protocol);
        reader.readStructBegin();
        while (reader.nextField()) {
            short fieldId = reader.getFieldId();
            ParameterMetadata parameter = method.getParameterByFieldId(fieldId);
            if (parameter == null) {
                reader.skipFieldData();
                continue;
            }
            arguments.put(fieldId, reader.readField(parameter.getCodec()));
        }
        reader.readStructEnd();
        for (ParameterMetadata parameter : method.getParameters()) {
            if (arguments.containsKey(parameter.getFieldId())) continue;
            Type argumentType = parameter.getCodec().getType().getJavaType();
            Object defaultValue = null;
            if (argumentType instanceof Class) {
                Class argumentClass = (Class)argumentType;
                if (argumentClass.isPrimitive()) {
                    defaultValue = Defaults.defaultValue((Class)Primitives.unwrap((Class)argumentClass));
                } else if (argumentClass == OptionalInt.class) {
                    defaultValue = OptionalInt.empty();
                } else if (argumentClass == OptionalLong.class) {
                    defaultValue = OptionalLong.empty();
                } else if (argumentClass == OptionalDouble.class) {
                    defaultValue = OptionalDouble.empty();
                }
            } else if (argumentType instanceof ParameterizedType && ((ParameterizedType)argumentType).getRawType().equals(Optional.class)) {
                defaultValue = Optional.empty();
            }
            arguments.put(parameter.getFieldId(), defaultValue);
        }
        return arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThriftFrame writeSuccessResponse(ChannelHandlerContext context, MethodMetadata methodMetadata, Transport transport, Protocol protocol, int sequenceId, boolean supportOutOfOrderResponse, Object result) throws Exception {
        TChannelBufferOutputTransport outputTransport = new TChannelBufferOutputTransport(context.alloc());
        try {
            ThriftServerHandler.writeResponse(methodMetadata.getName(), (TProtocolWriter)protocol.createProtocol(outputTransport), sequenceId, "success", (short)0, (ThriftCodec<Object>)methodMetadata.getResultCodec(), result);
            ThriftFrame thriftFrame = new ThriftFrame(sequenceId, outputTransport.getBuffer(), (Map<String, String>)ImmutableMap.of(), transport, protocol, supportOutOfOrderResponse);
            return thriftFrame;
        }
        finally {
            outputTransport.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThriftFrame writeExceptionResponse(ChannelHandlerContext context, MethodMetadata methodMetadata, Transport transport, Protocol protocol, int sequenceId, boolean supportOutOfOrderResponse, Throwable exception) throws Exception {
        Optional exceptionId = methodMetadata.getExceptionId(exception.getClass());
        if (exceptionId.isPresent()) {
            TChannelBufferOutputTransport outputTransport = new TChannelBufferOutputTransport(context.alloc());
            try {
                TProtocol protocolWriter = protocol.createProtocol(outputTransport);
                ThriftServerHandler.writeResponse(methodMetadata.getName(), (TProtocolWriter)protocolWriter, sequenceId, "exception", (Short)exceptionId.get(), (ThriftCodec<Object>)((ThriftCodec)methodMetadata.getExceptionCodecs().get(exceptionId.get())), exception);
                ThriftFrame thriftFrame = new ThriftFrame(sequenceId, outputTransport.getBuffer(), (Map<String, String>)ImmutableMap.of(), transport, protocol, supportOutOfOrderResponse);
                return thriftFrame;
            }
            finally {
                outputTransport.release();
            }
        }
        return ThriftServerHandler.writeApplicationException(context, methodMetadata.getName(), transport, protocol, sequenceId, supportOutOfOrderResponse, TApplicationException.Type.INTERNAL_ERROR, "Internal error processing " + methodMetadata.getName() + ": " + exception.getMessage(), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThriftFrame writeApplicationException(ChannelHandlerContext context, String methodName, Transport transport, Protocol protocol, int sequenceId, boolean supportOutOfOrderResponse, TApplicationException.Type errorCode, String errorMessage, Throwable cause) throws Exception {
        TApplicationException applicationException = new TApplicationException(errorCode, errorMessage);
        if (cause != null) {
            applicationException.initCause(cause);
        }
        TChannelBufferOutputTransport outputTransport = new TChannelBufferOutputTransport(context.alloc());
        try {
            TProtocol protocolWriter = protocol.createProtocol(outputTransport);
            protocolWriter.writeMessageBegin(new TMessage(methodName, 3, sequenceId));
            ExceptionWriter.writeTApplicationException(applicationException, (TProtocolWriter)protocolWriter);
            protocolWriter.writeMessageEnd();
            ThriftFrame thriftFrame = new ThriftFrame(sequenceId, outputTransport.getBuffer(), (Map<String, String>)ImmutableMap.of(), transport, protocol, supportOutOfOrderResponse);
            return thriftFrame;
        }
        finally {
            outputTransport.release();
        }
    }

    private static void writeResponse(String methodName, TProtocolWriter protocolWriter, int sequenceId, String responseFieldName, short responseFieldId, ThriftCodec<Object> responseCodec, Object result) throws Exception {
        protocolWriter.writeMessageBegin(new TMessage(methodName, 2, sequenceId));
        ProtocolWriter writer = new ProtocolWriter(protocolWriter);
        writer.writeStructBegin(methodName + "_result");
        writer.writeField(responseFieldName, responseFieldId, responseCodec, result);
        writer.writeStructEnd();
        protocolWriter.writeMessageEnd();
    }
}

