/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.ssl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.drift.transport.netty.ssl.ReloadableSslContext;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SslContextFactory {
    private final LoadingCache<SslContextConfig, ReloadableSslContext> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> new ReloadableSslContext(forClient, key.getTrustCertificatesFile(), key.getClientCertificatesFile(), key.getPrivateKeyFile(), key.getPrivateKeyPassword(), key.getSessionCacheSize(), key.getSessionTimeout(), key.getCiphers())));

    public static SslContextFactory createSslContextFactory(boolean forClient, Duration refreshTime, ScheduledExecutorService scheduledExecutor) {
        SslContextFactory sslContextFactory = new SslContextFactory(forClient);
        scheduledExecutor.scheduleWithFixedDelay(sslContextFactory::refresh, refreshTime.toMillis(), refreshTime.toMillis(), TimeUnit.MILLISECONDS);
        return sslContextFactory;
    }

    private SslContextFactory(boolean forClient) {
    }

    public ReloadableSslContext get(File trustCertificatesFile, Optional<File> clientCertificatesFile, Optional<File> privateKeyFile, Optional<String> privateKeyPassword, long sessionCacheSize, Duration sessionTimeout, List<String> ciphers) {
        try {
            return (ReloadableSslContext)this.cache.getUnchecked((Object)new SslContextConfig(trustCertificatesFile, clientCertificatesFile, privateKeyFile, privateKeyPassword, sessionCacheSize, sessionTimeout, ciphers));
        }
        catch (ExecutionError | UncheckedExecutionException e) {
            throw new RuntimeException("Error initializing SSL context", e.getCause());
        }
    }

    private void refresh() {
        this.cache.asMap().values().forEach(ReloadableSslContext::reload);
    }

    private static class SslContextConfig {
        private final File trustCertificatesFile;
        private final Optional<File> clientCertificatesFile;
        private final Optional<File> privateKeyFile;
        private final Optional<String> privateKeyPassword;
        private final long sessionCacheSize;
        private final Duration sessionTimeout;
        private final List<String> ciphers;

        public SslContextConfig(File trustCertificatesFile, Optional<File> clientCertificatesFile, Optional<File> privateKeyFile, Optional<String> privateKeyPassword, long sessionCacheSize, Duration sessionTimeout, List<String> ciphers) {
            this.trustCertificatesFile = Objects.requireNonNull(trustCertificatesFile, "trustCertificatesFile is null");
            this.clientCertificatesFile = Objects.requireNonNull(clientCertificatesFile, "clientCertificatesFile is null");
            this.privateKeyFile = Objects.requireNonNull(privateKeyFile, "privateKeyFile is null");
            this.privateKeyPassword = Objects.requireNonNull(privateKeyPassword, "privateKeyPassword is null");
            this.sessionCacheSize = sessionCacheSize;
            this.sessionTimeout = Objects.requireNonNull(sessionTimeout, "sessionTimeout is null");
            this.ciphers = ImmutableList.copyOf((Collection)Objects.requireNonNull(ciphers, "ciphers is null"));
        }

        public File getTrustCertificatesFile() {
            return this.trustCertificatesFile;
        }

        public Optional<File> getClientCertificatesFile() {
            return this.clientCertificatesFile;
        }

        public Optional<File> getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public Optional<String> getPrivateKeyPassword() {
            return this.privateKeyPassword;
        }

        public long getSessionCacheSize() {
            return this.sessionCacheSize;
        }

        public Duration getSessionTimeout() {
            return this.sessionTimeout;
        }

        public List<String> getCiphers() {
            return this.ciphers;
        }
    }
}

