/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.metadata.ThriftMethodMetadata;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.transport.ParameterMetadata;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MethodMetadata {
    private final String name;
    private final List<ParameterMetadata> parameters;
    private final Map<Short, ParameterMetadata> parametersById;
    private final ThriftCodec<Object> resultCodec;
    private final Map<Short, ThriftCodec<Object>> exceptionCodecs;
    private final Map<Class<?>, Short> exceptionIdsByType;
    private final boolean oneway;
    private final boolean idempotent;

    public static MethodMetadata toMethodMetadata(ThriftCodecManager codecManager, ThriftMethodMetadata metadata) {
        List<ParameterMetadata> parameters = metadata.getParameters().stream().map(parameter -> new ParameterMetadata(parameter.getId(), parameter.getName(), MethodMetadata.getCodec(codecManager, parameter.getThriftType()))).collect(Collectors.toList());
        ThriftCodec<Object> resultCodec = MethodMetadata.getCodec(codecManager, metadata.getReturnType());
        ImmutableMap exceptionCodecs = ImmutableMap.copyOf((Map)Maps.transformEntries((Map)metadata.getExceptions(), (key, value) -> MethodMetadata.getCodec(codecManager, value)));
        return new MethodMetadata(metadata.getName(), parameters, resultCodec, (Map<Short, ThriftCodec<Object>>)exceptionCodecs, metadata.getOneway(), metadata.isIdempotent());
    }

    private static ThriftCodec<Object> getCodec(ThriftCodecManager codecManager, ThriftType thriftType) {
        return codecManager.getCodec(thriftType);
    }

    public MethodMetadata(String name, List<ParameterMetadata> parameters, ThriftCodec<Object> resultCodec, Map<Short, ThriftCodec<Object>> exceptionCodecs, boolean oneway, boolean idempotent) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.parametersById = (Map)parameters.stream().collect(ImmutableMap.toImmutableMap(ParameterMetadata::getFieldId, Function.identity()));
        this.resultCodec = Objects.requireNonNull(resultCodec, "resultCodec is null");
        this.exceptionCodecs = ImmutableMap.copyOf(Objects.requireNonNull(exceptionCodecs, "exceptionCodecs is null"));
        ImmutableMap.Builder exceptions = ImmutableMap.builder();
        for (Map.Entry<Short, ThriftCodec<Object>> entry : exceptionCodecs.entrySet()) {
            exceptions.put((Object)TypeToken.of((Type)entry.getValue().getType().getJavaType()).getRawType(), (Object)entry.getKey());
        }
        this.exceptionIdsByType = exceptions.build();
        this.oneway = oneway;
        this.idempotent = idempotent;
    }

    public String getName() {
        return this.name;
    }

    public List<ParameterMetadata> getParameters() {
        return this.parameters;
    }

    public ParameterMetadata getParameterByFieldId(short fieldId) {
        return this.parametersById.get(fieldId);
    }

    public ThriftCodec<Object> getResultCodec() {
        return this.resultCodec;
    }

    public Map<Short, ThriftCodec<Object>> getExceptionCodecs() {
        return this.exceptionCodecs;
    }

    public Optional<Short> getExceptionId(Class<? extends Throwable> exceptionType) {
        Short exceptionId = this.exceptionIdsByType.get(exceptionType);
        if (exceptionId != null) {
            return Optional.of(exceptionId);
        }
        for (Map.Entry<Class<?>, Short> entry : this.exceptionIdsByType.entrySet()) {
            if (!entry.getKey().isAssignableFrom(exceptionType)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("parameters", this.parameters).toString();
    }
}

