/*
 * Copyright (C) 2013 Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.airlift.drift.transport.client;

import io.airlift.drift.TException;

import java.util.Optional;

import static java.util.Objects.requireNonNull;

public final class DriftApplicationException
        extends TException
{
    private final Optional<Boolean> retryable;

    public DriftApplicationException(Throwable applicationException, Optional<Boolean> retryable)
    {
        super(requireNonNull(applicationException, "applicationException is null"));
        this.retryable = requireNonNull(retryable, "retryable is null");
    }

    public Optional<Boolean> isRetryable()
    {
        return retryable;
    }
}
