/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.client;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class DriftClientConfig {
    private int maxRetries = 5;
    private Duration minBackoffDelay = new Duration(100.0, TimeUnit.MILLISECONDS);
    private Duration maxBackoffDelay = new Duration(30.0, TimeUnit.SECONDS);
    private double backoffScaleFactor = 2.0;
    private Duration maxRetryTime = new Duration(1.0, TimeUnit.MINUTES);
    private boolean statsEnabled = true;

    @Min(value=0L)
    public @Min(value=0L) int getMaxRetries() {
        return this.maxRetries;
    }

    @Config(value="thrift.client.max-retries")
    @ConfigDescription(value="Minimum number of retry attempts")
    public DriftClientConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getMinBackoffDelay() {
        return this.minBackoffDelay;
    }

    @Config(value="thrift.client.min-backoff-delay")
    @ConfigDescription(value="Minimum delay between request retries")
    public DriftClientConfig setMinBackoffDelay(Duration minBackoffDelay) {
        this.minBackoffDelay = minBackoffDelay;
        return this;
    }

    @MinDuration(value="1s")
    @NotNull
    public @MinDuration(value="1s") @NotNull Duration getMaxBackoffDelay() {
        return this.maxBackoffDelay;
    }

    @Config(value="thrift.client.max-backoff-delay")
    @ConfigDescription(value="Maximum delay between request retries")
    public DriftClientConfig setMaxBackoffDelay(Duration maxBackoffDelay) {
        this.maxBackoffDelay = maxBackoffDelay;
        return this;
    }

    public double getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    @Config(value="thrift.client.backoff-scale-factor")
    @ConfigDescription(value="Scale factor for request retry delay")
    public DriftClientConfig setBackoffScaleFactor(double backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Config(value="thrift.client.max-retry-time")
    @ConfigDescription(value="Total time limit for a request to be retried")
    public DriftClientConfig setMaxRetryTime(Duration maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
        return this;
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    @Config(value="thrift.client.stats.enabled")
    @ConfigDescription(value="Enable per-method JMX stats")
    public DriftClientConfig setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
        return this;
    }
}

