/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.ServiceType;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.EventSubmissionFailedException;
import io.airlift.event.client.ForEventClient;
import io.airlift.event.client.JsonEventWriter;
import io.airlift.event.client.ServiceUnavailableException;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class HttpEventClient
implements EventClient {
    private static final Logger log = Logger.get(HttpEventClient.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final HttpServiceSelector serviceSelector;
    private final JsonEventWriter eventWriter;
    private final HttpClient httpClient;
    private final NodeInfo nodeInfo;

    @Inject
    public HttpEventClient(@ServiceType(value="collector") HttpServiceSelector serviceSelector, JsonEventWriter eventWriter, NodeInfo nodeInfo, @ForEventClient HttpClient httpClient) {
        this.serviceSelector = Objects.requireNonNull(serviceSelector, "serviceSelector is null");
        this.eventWriter = Objects.requireNonNull(eventWriter, "eventWriter is null");
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    @Flatten
    @Managed
    public RequestStats getStats() {
        return this.httpClient.getStats();
    }

    @SafeVarargs
    public final <T> ListenableFuture<Void> post(T ... event) throws IllegalArgumentException {
        Objects.requireNonNull(event, "event is null");
        return this.post((Iterable<T>)Arrays.asList(event));
    }

    public <T> ListenableFuture<Void> post(Iterable<T> events) throws IllegalArgumentException {
        Objects.requireNonNull(events, "eventsSupplier is null");
        return this.post(eventPoster -> {
            for (Object event : events) {
                eventPoster.post(event);
            }
        });
    }

    public <T> ListenableFuture<Void> post(EventClient.EventGenerator<T> eventGenerator) {
        Objects.requireNonNull(eventGenerator, "eventGenerator is null");
        List uris = this.serviceSelector.selectHttpService();
        if (uris.isEmpty()) {
            return Futures.immediateFailedFuture((Throwable)new ServiceUnavailableException(this.serviceSelector.getType(), this.serviceSelector.getPool()));
        }
        byte[] events = HttpEventClient.writeEvents(this.eventWriter, eventGenerator);
        Request request = Request.Builder.preparePost().setUri(((URI)uris.get(0)).resolve("/v2/event")).setHeader("User-Agent", this.nodeInfo.getNodeId()).setHeader("Content-Type", MEDIA_TYPE_JSON.toString()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])events)).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)new EventResponseHandler(this.serviceSelector.getType(), this.serviceSelector.getPool()));
    }

    private static <T> byte[] writeEvents(JsonEventWriter eventWriter, EventClient.EventGenerator<T> events) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            eventWriter.writeEvents(events, (OutputStream)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toByteArray();
    }

    private static class EventResponseHandler
    implements ResponseHandler<Void, RuntimeException> {
        private final String type;
        private final String pool;

        public EventResponseHandler(String type, String pool) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.pool = Objects.requireNonNull(pool, "pool is null");
        }

        public Void handleException(Request request, Exception exception) {
            log.debug("Posting event to %s failed", new Object[]{request.getUri()});
            throw new EventSubmissionFailedException(this.type, this.pool, (Map)ImmutableMap.of((Object)request.getUri(), (Object)exception));
        }

        public Void handle(Request request, Response response) {
            int statusCode = response.getStatusCode();
            if (statusCode >= 200 && statusCode <= 299) {
                return null;
            }
            try {
                InputStream inputStream = response.getInputStream();
                String responseBody = CharStreams.toString((Readable)new InputStreamReader(inputStream));
                log.debug("Posting event to %s failed: status_code=%d body=%s", new Object[]{request.getUri(), statusCode, responseBody});
            }
            catch (IOException bodyError) {
                log.debug("Posting event to %s failed: status_code=%d error=%s", new Object[]{request.getUri(), statusCode, bodyError.getMessage()});
            }
            return null;
        }
    }
}

