/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.collect.ImmutableMap;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.EventJsonSerializer;
import io.airlift.event.client.EventTypeMetadata;
import io.airlift.event.client.InvalidEventException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class JsonEventWriter {
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, JsonSerializer<?>> serializers;

    @Inject
    public JsonEventWriter(Set<EventTypeMetadata<?>> eventTypes) {
        Objects.requireNonNull(eventTypes, "eventTypes is null");
        this.jsonFactory = new JsonFactory();
        ImmutableMap.Builder serializerBuilder = ImmutableMap.builder();
        for (EventTypeMetadata<?> eventType : eventTypes) {
            serializerBuilder.put(eventType.getEventClass(), new EventJsonSerializer(eventType));
        }
        this.serializers = serializerBuilder.build();
    }

    public <T> void writeEvents(EventClient.EventGenerator<T> events, OutputStream out) throws IOException {
        Objects.requireNonNull(events, "events is null");
        Objects.requireNonNull(out, "out is null");
        final JsonGenerator jsonGenerator = this.jsonFactory.createJsonGenerator(out, JsonEncoding.UTF8);
        jsonGenerator.writeStartArray();
        events.generate(new EventClient.EventPoster<T>(){

            @Override
            public void post(T event) throws IOException {
                JsonSerializer serializer = JsonEventWriter.this.getSerializer(event);
                if (serializer == null) {
                    throw new InvalidEventException("Event class [%s] has not been registered as an event", event.getClass().getName());
                }
                serializer.serialize(event, jsonGenerator, null);
            }
        });
        jsonGenerator.writeEndArray();
        jsonGenerator.flush();
    }

    private <T> JsonSerializer<T> getSerializer(T event) {
        return this.serializers.get(event.getClass());
    }
}

