/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.event.client.EventClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractEventClient
implements EventClient {
    @Override
    @SafeVarargs
    public final <T> ListenableFuture<Void> post(T ... event) throws IllegalArgumentException {
        Objects.requireNonNull(event, "event is null");
        return this.post((Iterable<T>)Arrays.asList(event));
    }

    @Override
    public final <T> ListenableFuture<Void> post(final Iterable<T> events) throws IllegalArgumentException {
        Objects.requireNonNull(events, "events is null");
        return this.post(new EventClient.EventGenerator<T>(){

            @Override
            public void generate(EventClient.EventPoster<T> eventPoster) throws IOException {
                for (Object event : events) {
                    Objects.requireNonNull(event, "event is null");
                    eventPoster.post(event);
                }
            }
        });
    }

    @Override
    public final <T> ListenableFuture<Void> post(EventClient.EventGenerator<T> eventGenerator) throws IllegalArgumentException {
        try {
            eventGenerator.generate(new EventClient.EventPoster<T>(){

                @Override
                public void post(T event) throws IOException {
                    Objects.requireNonNull(event, "event is null");
                    AbstractEventClient.this.postEvent(event);
                }
            });
        }
        catch (IOException e) {
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return Futures.immediateCheckedFuture(null);
    }

    protected abstract <T> void postEvent(T var1) throws IOException;
}

