/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;

public class FullJsonResponseHandler<T>
implements ResponseHandler<JsonResponse<T>, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final JsonCodec<T> jsonCodec;

    public static <T> FullJsonResponseHandler<T> createFullJsonResponseHandler(JsonCodec<T> jsonCodec) {
        return new FullJsonResponseHandler<T>(jsonCodec);
    }

    private FullJsonResponseHandler(JsonCodec<T> jsonCodec) {
        this.jsonCodec = jsonCodec;
    }

    @Override
    public JsonResponse<T> handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public JsonResponse<T> handle(Request request, Response response) {
        byte[] bytes = FullJsonResponseHandler.readResponseBytes(response);
        String contentType = response.getHeader("Content-Type");
        if (contentType == null || !MediaType.parse((String)contentType).is(MEDIA_TYPE_JSON)) {
            return new JsonResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), bytes);
        }
        return new JsonResponse<T>(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), this.jsonCodec, bytes);
    }

    private static byte[] readResponseBytes(Response response) {
        try {
            return ByteStreams.toByteArray((InputStream)response.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading response from server", e);
        }
    }

    public static class JsonResponse<T> {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<HeaderName, String> headers;
        private final boolean hasValue;
        private final byte[] jsonBytes;
        private final byte[] responseBytes;
        private final T value;
        private final IllegalArgumentException exception;

        public JsonResponse(int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers, byte[] responseBytes) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.hasValue = false;
            this.jsonBytes = null;
            this.responseBytes = (byte[])Preconditions.checkNotNull((Object)responseBytes, (Object)"responseBytes is null");
            this.value = null;
            this.exception = null;
        }

        public JsonResponse(int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers, JsonCodec<T> jsonCodec, byte[] jsonBytes) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.jsonBytes = (byte[])Preconditions.checkNotNull((Object)jsonBytes, (Object)"jsonBytes is null");
            this.responseBytes = (byte[])Preconditions.checkNotNull((Object)jsonBytes, (Object)"responseBytes is null");
            Object value = null;
            IllegalArgumentException exception = null;
            try {
                value = jsonCodec.fromJson(jsonBytes);
            }
            catch (IllegalArgumentException e) {
                exception = new IllegalArgumentException("Unable to create " + jsonCodec.getType() + " from JSON response:\n" + this.getJson(), e);
            }
            this.hasValue = exception == null;
            this.value = value;
            this.exception = exception;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        @Nullable
        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)HeaderName.of(name));
            return values.isEmpty() ? null : (String)values.get(0);
        }

        public List<String> getHeaders(String name) {
            return this.headers.get((Object)HeaderName.of(name));
        }

        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public T getValue() {
            if (!this.hasValue) {
                throw new IllegalStateException("Response does not contain a JSON value", this.exception);
            }
            return this.value;
        }

        public int getResponseSize() {
            return this.responseBytes.length;
        }

        public byte[] getResponseBytes() {
            return (byte[])this.responseBytes.clone();
        }

        public String getResponseBody() {
            return new String(this.responseBytes, this.getCharset());
        }

        public byte[] getJsonBytes() {
            return this.jsonBytes == null ? null : (byte[])this.jsonBytes.clone();
        }

        public String getJson() {
            return this.jsonBytes == null ? null : new String(this.jsonBytes, StandardCharsets.UTF_8);
        }

        public IllegalArgumentException getException() {
            return this.exception;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", this.headers).add("hasValue", this.hasValue).add("value", this.value).toString();
        }

        private Charset getCharset() {
            String value = this.getHeader("Content-Type");
            if (value != null) {
                try {
                    return (Charset)MediaType.parse((String)value).charset().or((Object)StandardCharsets.UTF_8);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return StandardCharsets.UTF_8;
        }
    }
}

