/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.testing;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CountingInputStream;
import com.google.common.net.MediaType;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class TestingResponse
implements Response {
    private final HttpStatus status;
    private final ListMultimap<HeaderName, String> headers;
    private final CountingInputStream countingInputStream;

    public TestingResponse(HttpStatus status, ListMultimap<String, String> headers, byte[] bytes) {
        this(status, headers, new ByteArrayInputStream((byte[])Preconditions.checkNotNull((Object)bytes, (Object)"bytes is null")));
    }

    public TestingResponse(HttpStatus status, ListMultimap<String, String> headers, InputStream input) {
        this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status is null"));
        this.headers = ImmutableListMultimap.copyOf(TestingResponse.toHeaderMap((ListMultimap<String, String>)((ListMultimap)Preconditions.checkNotNull(headers, (Object)"headers is null"))));
        this.countingInputStream = new CountingInputStream((InputStream)Preconditions.checkNotNull((Object)input, (Object)"input is null"));
    }

    @Override
    public int getStatusCode() {
        return this.status.code();
    }

    @Override
    public String getStatusMessage() {
        return this.status.reason();
    }

    @Override
    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBytesRead() {
        return this.countingInputStream.getCount();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.countingInputStream;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statusCode", this.getStatusCode()).add("statusMessage", (Object)this.getStatusMessage()).add("headers", this.getHeaders()).toString();
    }

    public static ListMultimap<String, String> contentType(MediaType type) {
        return ImmutableListMultimap.of((Object)"Content-Type", (Object)type.toString());
    }

    public static Response mockResponse(HttpStatus status, MediaType type, String content) {
        return new TestingResponse(status, TestingResponse.contentType(type), content.getBytes(Charsets.UTF_8));
    }

    private static ListMultimap<HeaderName, String> toHeaderMap(ListMultimap<String, String> headers) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : headers.entries()) {
            builder.put((Object)HeaderName.of((String)entry.getKey()), entry.getValue());
        }
        return builder.build();
    }
}

