/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.http.client.GlobalFilter;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.client.jetty.JettyIoPool;
import io.airlift.http.client.jetty.JettyIoPoolConfig;
import io.airlift.http.client.spnego.KerberosConfig;
import io.airlift.log.Logger;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.weakref.jmx.guice.ExportBinder;

@Beta
public class HttpClientModule
implements Module {
    private static final Logger log = Logger.get(HttpClientModule.class);
    protected final String name;
    protected final Class<? extends Annotation> annotation;
    protected Binder binder;

    public HttpClientModule(String name, Class<? extends Annotation> annotation) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.annotation = (Class)Preconditions.checkNotNull(annotation, (Object)"annotation is null");
    }

    void withConfigDefaults(ConfigDefaults<HttpClientConfig> configDefaults) {
        ConfigBinder.configBinder((Binder)this.binder).bindConfigDefaults(HttpClientConfig.class, this.annotation, configDefaults);
    }

    void withPrivateIoThreadPool() {
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(JettyIoPoolConfig.class, this.annotation, this.name);
        this.binder.bind(JettyIoPoolManager.class).annotatedWith(this.annotation).toInstance((Object)new JettyIoPoolManager(this.name, this.annotation));
    }

    public void configure(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null");
        ConfigBinder.configBinder((Binder)binder).bindConfig(KerberosConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpClientConfig.class, this.annotation, this.name);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JettyIoPoolConfig.class);
        binder.bind(JettyIoPoolManager.class).to(SharedJettyIoPoolManager.class).in(Scopes.SINGLETON);
        binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.name, this.annotation)).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, GlobalFilter.class);
        Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, this.annotation);
        ExportBinder.newExporter((Binder)binder).export(HttpClient.class).annotatedWith(this.annotation).withGeneratedName();
    }

    public void addAlias(Class<? extends Annotation> alias) {
        this.binder.bind(HttpClient.class).annotatedWith(alias).to(Key.get(HttpClient.class, this.annotation));
    }

    private static <T> Key<T> keyFromNullable(Class<T> type, Class<? extends Annotation> annotation) {
        return annotation != null ? Key.get(type, annotation) : Key.get(type);
    }

    @VisibleForTesting
    public static class JettyIoPoolManager {
        private final List<JettyHttpClient> clients = new ArrayList<JettyHttpClient>();
        private final String name;
        private final Class<? extends Annotation> annotation;
        private final AtomicBoolean destroyed = new AtomicBoolean();
        private JettyIoPool pool;
        private Injector injector;

        private JettyIoPoolManager(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        public void addClient(JettyHttpClient client) {
            this.clients.add(client);
        }

        public boolean isDestroyed() {
            return this.destroyed.get();
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        @PreDestroy
        public void destroy() {
            for (JettyHttpClient client : this.clients) {
                client.close();
            }
            if (this.pool != null) {
                this.pool.close();
                this.pool = null;
            }
            this.destroyed.set(true);
        }

        public JettyIoPool get() {
            if (this.pool == null) {
                JettyIoPoolConfig config = (JettyIoPoolConfig)this.injector.getInstance(HttpClientModule.keyFromNullable(JettyIoPoolConfig.class, this.annotation));
                this.pool = new JettyIoPool(this.name, config);
            }
            return this.pool;
        }
    }

    private static class SharedJettyIoPoolManager
    extends JettyIoPoolManager {
        private SharedJettyIoPoolManager() {
            super("shared", null);
        }
    }

    private static class HttpClientProvider
    implements Provider<HttpClient> {
        private final String name;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private HttpClientProvider(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public HttpClient get() {
            JettyIoPoolManager ioPoolProvider;
            KerberosConfig kerberosConfig = (KerberosConfig)this.injector.getInstance(KerberosConfig.class);
            HttpClientConfig config = (HttpClientConfig)this.injector.getInstance(Key.get(HttpClientConfig.class, this.annotation));
            ImmutableSet filters = ImmutableSet.builder().addAll((Iterable)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, GlobalFilter.class))).addAll((Iterable)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<HttpRequestFilter>>(){}, this.annotation))).build();
            if (this.injector.getExistingBinding(Key.get(JettyIoPoolManager.class, this.annotation)) != null) {
                log.debug("HttpClient %s uses private IO thread pool", new Object[]{this.name});
                ioPoolProvider = (JettyIoPoolManager)this.injector.getInstance(Key.get(JettyIoPoolManager.class, this.annotation));
            } else {
                log.debug("HttpClient %s uses shared IO thread pool", new Object[]{this.name});
                ioPoolProvider = (JettyIoPoolManager)this.injector.getInstance(JettyIoPoolManager.class);
            }
            JettyHttpClient client = new JettyHttpClient(config, kerberosConfig, Optional.of(ioPoolProvider.get()), (Iterable<? extends HttpRequestFilter>)ImmutableList.copyOf((Collection)filters));
            ioPoolProvider.addClient(client);
            return client;
        }
    }
}

