/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;

public class StringResponseHandler
implements ResponseHandler<StringResponse, RuntimeException> {
    private static final StringResponseHandler STRING_RESPONSE_HANDLER = new StringResponseHandler();

    public static StringResponseHandler createStringResponseHandler() {
        return STRING_RESPONSE_HANDLER;
    }

    private StringResponseHandler() {
    }

    @Override
    public StringResponse handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public StringResponse handle(Request request, Response response) {
        try {
            String contentType = response.getHeader("Content-Type");
            if (contentType != null) {
                MediaType mediaType = MediaType.parse((String)contentType);
                return new StringResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), new String(ByteStreams.toByteArray((InputStream)response.getInputStream()), (Charset)mediaType.charset().or((Object)StandardCharsets.UTF_8)));
            }
            return new StringResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), new String(ByteStreams.toByteArray((InputStream)response.getInputStream()), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class StringResponse {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<HeaderName, String> headers;
        private final String body;

        public StringResponse(int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers, String body) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getBody() {
            return this.body;
        }

        @Nullable
        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)HeaderName.of(name));
            return values.isEmpty() ? null : (String)values.get(0);
        }

        public List<String> getHeaders(String name) {
            return this.headers.get((Object)HeaderName.of(name));
        }

        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }
    }
}

