/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.jetty.JettyIoPoolConfig;
import io.airlift.http.client.jetty.JettyLogging;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public final class JettyIoPool
implements Closeable {
    private final String name;
    private final QueuedThreadPool executor;
    private final ByteBufferPool byteBufferPool;
    private final Scheduler scheduler;

    public JettyIoPool(String name, JettyIoPoolConfig config) {
        this.name = name;
        try {
            String baseName = "http-client-" + name;
            QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads(), config.getMinThreads(), 60000, null);
            threadPool.setName(baseName);
            threadPool.setDaemon(true);
            threadPool.start();
            threadPool.setStopTimeout(2000L);
            threadPool.setDetailedDump(true);
            this.executor = threadPool;
            this.scheduler = config.getTimeoutConcurrency() == 1 && config.getTimeoutThreads() == 1 ? new ScheduledExecutorScheduler(baseName + "-scheduler", true, Thread.currentThread().getContextClassLoader()) : new ConcurrentScheduler(config.getTimeoutConcurrency(), Math.max(1, config.getTimeoutThreads() / config.getTimeoutConcurrency()), baseName + "-scheduler");
            this.scheduler.start();
            this.byteBufferPool = new MappedByteBufferPool();
        }
        catch (Exception e) {
            this.close();
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            JettyIoPool.closeQuietly((LifeCycle)this.executor);
        }
        finally {
            JettyIoPool.closeQuietly((LifeCycle)this.scheduler);
        }
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    static {
        JettyLogging.setup();
    }

    private static class ConcurrentScheduler
    extends AbstractLifeCycle
    implements Scheduler {
        private final int threadsPerScheduler;
        private final ScheduledExecutorService[] schedulers;
        private final ThreadFactory threadFactory;

        ConcurrentScheduler(int schedulerCount, int threadsPerScheduler, String threadBaseName) {
            Preconditions.checkArgument((schedulerCount > 0 ? 1 : 0) != 0, (Object)"schedulerCount must be at least one");
            this.schedulers = new ScheduledThreadPoolExecutor[schedulerCount];
            Preconditions.checkArgument((threadsPerScheduler > 0 ? 1 : 0) != 0, (Object)"threadsPerScheduler must be at least one");
            this.threadsPerScheduler = threadsPerScheduler;
            Objects.requireNonNull(threadBaseName, "threadBaseName is null");
            this.threadFactory = Threads.daemonThreadsNamed((String)(threadBaseName + "-timeout-%s"));
        }

        protected void doStart() {
            for (int i = 0; i < this.schedulers.length; ++i) {
                ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(this.threadsPerScheduler, this.threadFactory);
                scheduledExecutorService.setRemoveOnCancelPolicy(true);
                this.schedulers[i] = scheduledExecutorService;
            }
        }

        protected void doStop() {
            for (int i = 0; i < this.schedulers.length; ++i) {
                this.schedulers[i].shutdownNow();
                this.schedulers[i] = null;
            }
        }

        public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
            ScheduledExecutorService scheduler = this.schedulers[ThreadLocalRandom.current().nextInt(this.schedulers.length)];
            if (scheduler == null) {
                return () -> false;
            }
            ScheduledFuture<?> result = scheduler.schedule(task, delay, unit);
            return () -> result.cancel(false);
        }
    }
}

