/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import javax.validation.constraints.Min;

public class JettyIoPoolConfig {
    private int maxThreads = 200;
    private int minThreads = 8;
    private int timeoutThreads = 1;
    private int timeoutConcurrency = 1;

    @Min(value=1L)
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-client.max-threads")
    @LegacyConfig(value={"http-client.threads"})
    public JettyIoPoolConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    @Min(value=1L)
    public int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-client.min-threads")
    public JettyIoPoolConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    @Min(value=1L)
    public int getTimeoutThreads() {
        return this.timeoutThreads;
    }

    @Config(value="http-client.timeout-threads")
    @ConfigDescription(value="Total number of timeout threads")
    public JettyIoPoolConfig setTimeoutThreads(int timeoutThreads) {
        this.timeoutThreads = timeoutThreads;
        return this;
    }

    @Min(value=1L)
    public int getTimeoutConcurrency() {
        return this.timeoutConcurrency;
    }

    @Config(value="http-client.timeout-concurrency")
    @ConfigDescription(value="Number of concurrent locks for timeout")
    public JettyIoPoolConfig setTimeoutConcurrency(int timeoutConcurrency) {
        this.timeoutConcurrency = timeoutConcurrency;
        return this;
    }
}

