/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;

public interface HttpClientLogger {
    public void log(RequestInfo var1, ResponseInfo var2);

    public void close();

    public int getQueueSize();

    public static class ResponseInfo {
        private final Optional<Response> response;
        private final Optional<Throwable> failureCause;
        private final long responseSize;
        private final long responseTimestampMillis = System.currentTimeMillis();

        private ResponseInfo(Optional<Response> response, long responseSize, Optional<Throwable> failure) {
            Objects.requireNonNull(response, "response is null");
            Objects.requireNonNull(failure, "failure is null");
            this.response = response;
            this.responseSize = responseSize;
            this.failureCause = failure;
        }

        public static ResponseInfo from(Optional<Response> response, long responseSize) {
            Objects.requireNonNull(response, "response is null");
            Preconditions.checkArgument((responseSize >= 0L ? 1 : 0) != 0, (Object)"responseSize is negative");
            return new ResponseInfo(response, responseSize, Optional.empty());
        }

        public static ResponseInfo failed(Optional<Response> response, Optional<Throwable> failureCause) {
            Objects.requireNonNull(response, "response is null");
            Objects.requireNonNull(failureCause, "failureCause is null");
            return new ResponseInfo(response, -1L, failureCause);
        }

        public Optional<Response> getResponse() {
            return this.response;
        }

        public long getResponseSize() {
            return this.responseSize;
        }

        public Optional<Throwable> getFailureCause() {
            return this.failureCause;
        }

        public long getResponseTimestampMillis() {
            return this.responseTimestampMillis;
        }
    }

    public static class RequestInfo {
        private final Request request;
        private final long requestTimestampMillis;

        private RequestInfo(Request request, long requestTimestampMillis) {
            Preconditions.checkArgument((requestTimestampMillis >= 0L ? 1 : 0) != 0, (Object)"requestTimestampMillis is negative");
            this.request = Objects.requireNonNull(request, "request is null");
            this.requestTimestampMillis = requestTimestampMillis;
        }

        public static RequestInfo from(Request request, long requestTimestampMillis) {
            Objects.requireNonNull(request, "request is null");
            Preconditions.checkArgument((requestTimestampMillis >= 0L ? 1 : 0) != 0, (Object)"requestTimestampMillis is negative");
            return new RequestInfo(request, requestTimestampMillis);
        }

        public Request getRequest() {
            return this.request;
        }

        public long getRequestTimestampMillis() {
            return this.requestTimestampMillis;
        }
    }
}

