/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.http.client.jetty.HttpClientLogger;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;

class HttpRequestEvent {
    static final int NO_RESPONSE = -1;
    private final Instant timeStamp;
    private final String protocolVersion;
    private final String method;
    private final String requestUri;
    private final String traceToken;
    private final long responseSize;
    private final int responseCode;
    private final long timeToLastByte;
    private final Optional<String> failureReason;

    private HttpRequestEvent(Instant timeStamp, String protocolVersion, String method, String requestUri, @Nullable String traceToken, long responseSize, int responseCode, long timeToLastByte, Optional<String> failureReason) {
        this.timeStamp = Objects.requireNonNull(timeStamp, "timeStamp is null");
        this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion is null");
        this.method = Objects.requireNonNull(method, "method is null");
        this.requestUri = Objects.requireNonNull(requestUri, "requestUri is null");
        this.traceToken = traceToken;
        this.responseSize = responseSize;
        this.responseCode = responseCode;
        this.timeToLastByte = timeToLastByte;
        this.failureReason = Objects.requireNonNull(failureReason, "failureReason is null");
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getTraceToken() {
        return this.traceToken;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public String getResponseCode() {
        return this.failureReason.orElseGet(() -> Integer.toString(this.responseCode));
    }

    public long getTimeToLastByte() {
        return this.timeToLastByte;
    }

    static HttpRequestEvent createHttpRequestEvent(HttpClientLogger.RequestInfo requestInfo, HttpClientLogger.ResponseInfo responseInfo) {
        String method;
        Objects.requireNonNull(requestInfo, "requestInfo is null");
        Objects.requireNonNull(responseInfo, "responseInfo is null");
        Request request = requestInfo.getRequest();
        Optional<Response> response = responseInfo.getResponse();
        String requestUri = null;
        if (request.getURI() != null) {
            requestUri = request.getURI().toString();
        }
        if ((method = request.getMethod()) != null) {
            method = method.toUpperCase(Locale.US);
        }
        long responseSize = -1L;
        int responseCode = -1;
        if (response.isPresent()) {
            responseSize = responseInfo.getResponseSize();
            responseCode = response.get().getStatus();
        }
        long timeToLastByte = Math.max(responseInfo.getResponseTimestampMillis() - requestInfo.getRequestTimestampMillis(), 0L);
        return new HttpRequestEvent(Instant.ofEpochMilli(requestInfo.getRequestTimestampMillis()), request.getVersion().toString(), method, requestUri, HttpRequestEvent.getHeader(request, "X-Airlift-Tracetoken"), responseSize, responseCode, timeToLastByte, HttpRequestEvent.getFailureReason(responseInfo));
    }

    @VisibleForTesting
    static Optional<String> getFailureReason(HttpClientLogger.ResponseInfo responseInfo) {
        Optional<Throwable> failure = responseInfo.getFailureCause();
        if (!failure.isPresent()) {
            return Optional.empty();
        }
        String className = failure.get().getClass().getSimpleName().toUpperCase(Locale.US);
        if (className.endsWith("EXCEPTION")) {
            return Optional.of(className.substring(0, className.lastIndexOf("EXCEPTION")));
        }
        return Optional.of(className);
    }

    @Nullable
    private static String getHeader(Request request, String header) {
        Objects.requireNonNull(header, "header is null");
        HttpFields headers = request.getHeaders();
        if (headers != null) {
            return headers.get(header);
        }
        return null;
    }
}

