/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.AbstractFuture;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.client.jetty.JettyResponse;
import io.airlift.log.Logger;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Response;

class JettyResponseFuture<T, E extends Exception>
extends AbstractFuture<T>
implements HttpClient.HttpResponseFuture<T> {
    private static final Logger log = Logger.get(JettyResponseFuture.class);
    private final long requestStart = System.nanoTime();
    private final AtomicReference<JettyAsyncHttpState> state = new AtomicReference<JettyAsyncHttpState>(JettyAsyncHttpState.WAITING_FOR_CONNECTION);
    private final Request request;
    private final org.eclipse.jetty.client.api.Request jettyRequest;
    private final ResponseHandler<T, E> responseHandler;
    private final RequestStats stats;
    private final boolean recordRequestComplete;

    public JettyResponseFuture(Request request, org.eclipse.jetty.client.api.Request jettyRequest, ResponseHandler<T, E> responseHandler, RequestStats stats, boolean recordRequestComplete) {
        this.request = request;
        this.jettyRequest = jettyRequest;
        this.responseHandler = responseHandler;
        this.stats = stats;
        this.recordRequestComplete = recordRequestComplete;
    }

    @Override
    public String getState() {
        return this.state.get().toString();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this.stats.recordRequestCanceled();
            this.state.set(JettyAsyncHttpState.CANCELED);
            this.jettyRequest.abort((Throwable)new CancellationException());
            return super.cancel(mayInterruptIfRunning);
        }
        catch (Throwable e) {
            this.setException(e);
            return true;
        }
    }

    protected void completed(Response response, InputStream content) {
        T value;
        if (this.state.get() == JettyAsyncHttpState.CANCELED) {
            return;
        }
        try {
            value = this.processResponse(response, content);
        }
        catch (Throwable e) {
            this.storeException(e);
            return;
        }
        this.state.set(JettyAsyncHttpState.DONE);
        this.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T processResponse(Response response, InputStream content) throws E {
        T value;
        long responseStart = System.nanoTime();
        this.state.set(JettyAsyncHttpState.PROCESSING_RESPONSE);
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, content);
            value = this.responseHandler.handle(this.request, jettyResponse);
        }
        finally {
            if (this.recordRequestComplete) {
                JettyHttpClient.recordRequestComplete(this.stats, this.request, this.requestStart, jettyResponse, responseStart);
            }
        }
        return value;
    }

    protected void failed(Throwable throwable) {
        if (this.state.get() == JettyAsyncHttpState.CANCELED) {
            return;
        }
        this.stats.recordRequestFailed();
        if (throwable instanceof Exception) {
            try {
                T value = this.responseHandler.handleException(this.request, (Exception)throwable);
                this.state.set(JettyAsyncHttpState.DONE);
                this.set(value);
                return;
            }
            catch (Throwable newThrowable) {
                throwable = newThrowable;
            }
        }
        this.storeException(throwable);
    }

    private void storeException(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.state.set(JettyAsyncHttpState.CANCELED);
        } else {
            this.state.set(JettyAsyncHttpState.FAILED);
        }
        if (throwable == null) {
            throwable = new Throwable("Throwable is null");
            log.error(throwable, "Something is broken");
        }
        this.setException(throwable);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestStart", this.requestStart).add("state", this.state).add("request", (Object)this.request).toString();
    }

    public static enum JettyAsyncHttpState {
        WAITING_FOR_CONNECTION,
        SENDING_REQUEST,
        WAITING_FOR_RESPONSE,
        PROCESSING_RESPONSE,
        DONE,
        FAILED,
        CANCELED;

    }
}

